/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariDriverService;

public class SafariTechPreviewDriverInfo
implements WebDriverInfo {
    @Override
    public String getDisplayName() {
        return "Safari Technology Preview";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", "Safari Technology Preview");
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        if ("Safari Technology Preview".equals(capabilities.getBrowserName())) {
            return true;
        }
        return capabilities.asMap().keySet().parallelStream().map(key -> key.startsWith("safari.") || key.startsWith("safari:")).reduce(Boolean::logicalOr).orElse(false);
    }

    @Override
    public boolean isAvailable() {
        try {
            SafariDriverService.createDefaultService(this.getCanonicalCapabilities());
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new SafariDriver(capabilities));
    }
}

