# Generated by default/object.tt
package Paws::SageMaker::ProfilerConfigForUpdate;
  use Moose;
  has DisableProfiler => (is => 'ro', isa => 'Bool');
  has ProfilingIntervalInMilliseconds => (is => 'ro', isa => 'Int');
  has ProfilingParameters => (is => 'ro', isa => 'Paws::SageMaker::ProfilingParameters');
  has S3OutputPath => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProfilerConfigForUpdate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProfilerConfigForUpdate object:

  $service_obj->Method(Att1 => { DisableProfiler => $value, ..., S3OutputPath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProfilerConfigForUpdate object:

  $result = $service_obj->Method(...);
  $result->Att1->DisableProfiler

=head1 DESCRIPTION

Configuration information for updating the Debugger profile parameters,
system and framework metrics configurations, and storage paths.

=head1 ATTRIBUTES


=head2 DisableProfiler => Bool

To disable Debugger monitoring and profiling, set to C<True>.


=head2 ProfilingIntervalInMilliseconds => Int

A time interval for capturing system metrics in milliseconds. Available
values are 100, 200, 500, 1000 (1 second), 5000 (5 seconds), and 60000
(1 minute) milliseconds. The default value is 500 milliseconds.


=head2 ProfilingParameters => L<Paws::SageMaker::ProfilingParameters>

Configuration information for capturing framework metrics. Available
key strings for different profiling options are
C<DetailedProfilingConfig>, C<PythonProfilingConfig>, and
C<DataLoaderProfilingConfig>. The following codes are configuration
structures for the C<ProfilingParameters> parameter. To learn more
about how to configure the C<ProfilingParameters> parameter, see Use
the SageMaker and Debugger Configuration API Operations to Create,
Update, and Debug Your Training Job
(https://docs.aws.amazon.com/sagemaker/latest/dg/debugger-createtrainingjob-api.html).


=head2 S3OutputPath => Str

Path to Amazon S3 storage location for system and framework metrics.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

