#!perl

use Test::More;
use Crypt::PKCS11 qw(:constant);
use Crypt::PKCS11::Attribute;
use Crypt::PKCS11::Attributes;
use Crypt::PKCS11::Object;
use Crypt::PKCS11::Session;
use Scalar::Util qw(blessed);

our $HAVE_LEAKTRACE;
our $LEAK_TESTING;

sub myok {
    my ($res, $name) = @_;
    my ($package, $filename, $line) = caller;

    unless ($LEAK_TESTING) {
        ok( $res, $filename.'@'.$line.($name?': '.$name:'') );
    }
}

sub myisa_ok {
    my ($obj, $class, $name) = @_;
    my ($package, $filename, $line) = caller;

    unless ($LEAK_TESTING) {
        isa_ok( $obj, $class, $filename.'@'.$line.($name?': '.$name:'') );
    }
}

sub myis {
    my ($a, $b, $n) = @_;
    my ($package, $filename, $line) = caller;

    unless ($LEAK_TESTING) {
        is( $a, $b, $filename.'@'.$line.($n?': '.$n:'') );
    }
}

sub myis2 {
    my $a = shift;
    my $n = pop;
    my ($package, $filename, $line) = caller;

    unless ($LEAK_TESTING) {
        foreach (@_) {
            if ($a == $_) {
                is( $a, $_, $filename.'@'.$line.($n?': '.$n:'') );
                return;
            }
        }
        is( $a, $_[0], $filename.'@'.$line.($n?': '.$n:'') );
    }
}

sub myisnt {
    my ($a, $b, $n) = @_;
    my ($package, $filename, $line) = caller;

    unless ($LEAK_TESTING) {
        isnt( $a, $b, $filename.'@'.$line.($n?': '.$n:'') );
    }
}

sub mytests {

# TODO: Test GetAttributeValue more

# Crypt/PKCS11.pm

$obj = eval {
    local $SIG{__WARN__} = sub {};
    Crypt::PKCS11::new;
};
myok( blessed $obj, 'Crypt::PKCS11::new' );
myisa_ok( $obj = Crypt::PKCS11->new, 'Crypt::PKCS11', 'Crypt::PKCS11->new' );
myisa_ok( $obj = $obj->new, 'Crypt::PKCS11', '$obj->new' );
$@ = undef; eval { $obj->load(undef); };
myok( $@, '$obj->load(undef)' );
myis( $obj->load('FAKE'), undef, '$obj->load(FAKE)' );
myis( $obj->unload, undef, '$obj->unload' );
$@ = undef; eval { $obj->Initialize(undef); };
myok( $@, '$obj->Initialize(undef)' );
myis( $obj->Initialize({}), undef, '$obj->Initialize({})' );
$@ = undef; eval { $obj->Initialize({ CreateMutex => undef }); };
myok( $@, '$obj->Initialize({ CreateMutex => undef })' );
$@ = undef; eval { $obj->Initialize({ DestroyMutex => undef }); };
myok( $@, '$obj->Initialize({ DestroyMutex => undef })' );
$@ = undef; eval { $obj->Initialize({ LockMutex => undef }); };
myok( $@, '$obj->Initialize({ LockMutex => undef })' );
$@ = undef; eval { $obj->Initialize({ UnlockMutex => undef }); };
myok( $@, '$obj->Initialize({ UnlockMutex => undef })' );
$@ = undef; eval { $obj->Initialize({ CreateMutex => sub{} }); };
myok( $@, '$obj->Initialize({ CreateMutex => sub{} })' );
$@ = undef; eval { $obj->Initialize({ CreateMutex => sub{}, DestroyMutex => sub{} }); };
myok( $@, '$obj->Initialize({ CreateMutex => sub{}, DestroyMutex => sub{} })' );
$@ = undef; eval { $obj->Initialize({ CreateMutex => sub{}, DestroyMutex => sub{}, LockMutex => sub{} }); };
myok( $@, '$obj->Initialize({ CreateMutex => sub{}, DestroyMutex => sub{}, LockMutex => sub{} })' );
$@ = undef; eval { Crypt::PKCS11::XS::setCreateMutex($a = undef); };
myok( $@, 'Crypt::PKCS11::XS::setCreateMutex' );
$@ = undef; eval { Crypt::PKCS11::XS::setDestroyMutex($a = undef); };
myok( $@, 'Crypt::PKCS11::XS::setDestroyMutex' );
$@ = undef; eval { Crypt::PKCS11::XS::setLockMutex($a = undef); };
myok( $@, 'Crypt::PKCS11::XS::setLockMutex' );
$@ = undef; eval { Crypt::PKCS11::XS::setUnlockMutex($a = undef); };
myok( $@, 'Crypt::PKCS11::XS::setUnlockMutex' );
myis( $obj->Initialize, undef, '$obj->Initialize' );
myis( $obj->Finalize, undef, '$obj->Finalize' );
myis( $obj->GetInfo, undef, '$obj->GetInfo' );
myis( $obj->GetSlotList, undef, '$obj->GetSlotList' );
$@ = undef; eval { $obj->GetSlotInfo; };
myok( $@, '$obj->GetSlotInfo' );
myis( $obj->GetSlotInfo(1), undef, '$obj->GetSlotInfo' );
$@ = undef; eval { $obj->GetTokenInfo; };
myok( $@, '$obj->GetTokenInfo' );
myis( $obj->GetTokenInfo(1), undef, '$obj->GetTokenInfo' );
$@ = undef; eval { $obj->GetMechanismList; };
myok( $@, '$obj->GetMechanismList' );
myis( $obj->GetMechanismList(1), undef, '$obj->GetMechanismList' );
$@ = undef; eval { $obj->GetMechanismInfo; };
myok( $@, '$obj->GetMechanismInfo' );
$@ = undef; eval { $obj->GetMechanismInfo(1); };
myok( $@, '$obj->GetMechanismInfo' );
myis( $obj->GetMechanismInfo(1, 1), undef, '$obj->GetMechanismInfo' );
$@ = undef; eval { $obj->InitToken; };
myok( $@, '$obj->InitToken' );
$@ = undef; eval { $obj->InitToken(undef, undef); };
myok( $@, '$obj->InitToken(undef, undef)' );
$@ = undef; eval { $obj->InitToken(1, undef); };
myok( $@, '$obj->InitToken(1, undef)' );
myis( $obj->InitToken(1, 1), undef, '$obj->InitToken' );
myis( $obj->InitToken(1, 1, 1), undef, '$obj->InitToken' );
myis( $obj->InitToken(1, undef, 1), undef, '$obj->InitToken' );
$@ = undef; eval { $obj->OpenSession(undef); };
myok( $@, '$obj->OpenSession(undef)' );
$@ = undef; eval { $obj->OpenSession(1, undef, 1); };
myok( $@, '$obj->OpenSession(1, undef, 1)' );
myis( $obj->OpenSession(1, undef, sub{}), undef, '$obj->OpenSession(1, undef, sub{})' );
$@ = undef; eval { $obj->CloseAllSessions; };
myok( $@, '$obj->CloseAllSessions' );
myis( $obj->CloseAllSessions(1), undef, '$obj->CloseAllSessions' );
myis( $obj->WaitForSlotEvent, undef, '$obj->WaitForSlotEvent' );
myok( $obj->errno, '$obj->errno' );

{
    local $SIG{__WARN__} = sub {};
    my $sub;

    $sub = *Crypt::PKCS11::XSPtr::C_WaitForSlotEvent{CODE};
    *Crypt::PKCS11::XSPtr::C_WaitForSlotEvent = sub ($$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->WaitForSlotEvent, '$obj->WaitForSlotEvent' );
    *Crypt::PKCS11::XSPtr::C_WaitForSlotEvent = sub ($$) { return CKR_GENERAL_ERROR; };
    myis( $obj->WaitForSlotEvent, undef, '$obj->WaitForSlotEvent' );
    *Crypt::PKCS11::XSPtr::C_WaitForSlotEvent = $sub;
}

$@ = undef; eval { Crypt::PKCS11::struct::toBytes; };
myok( $@, 'Crypt::PKCS11::struct::toBytes' );

my $mechanism = Crypt::PKCS11::CK_MECHANISM->new;
$mechanism->set_mechanism(CKM_RSA_PKCS_KEY_PAIR_GEN);
$mechanism->set_pParameter('abc');
myisa_ok( $mechanism->toHash, 'HASH', '$mechanism->toHash' );

$rv = 0;
if ($ENV{TEST_DEVEL_COVER}) {
    myisa_ok( $xs = Crypt::PKCS11::XS->new, 'Crypt::PKCS11::XSPtr' );
    myis( $xs->load('TEST_DEVEL_COVER_NO_FLIST'), CKR_GENERAL_ERROR );
    myis( $xs->load('TEST_DEVEL_COVER'), CKR_OK );
    $rv = $xs->test_devel_cover;
    myis( $rv, 0, 'Failed on line '.$rv );
    $rv = Crypt::PKCS11::STRUCT_XS::test_devel_cover;
    myis( $rv, 0, 'Failed on line '.$rv );

    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([], 1), CKR_OK );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([undef], 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([1], 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([[]], 1), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{}], 1), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1}], 0), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>-1}], 0), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>''}], 0), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1, pValue=>undef}], 0), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1, pValue=>undef}], 1), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1}], 1), CKR_OK );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1, pValue=>''}], 0), CKR_OK );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_check_pTemplate([{type=>1, pValue=>''}], 1), CKR_OK );

    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([undef], 1, 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([1], 1, 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([[]], 1, 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{}], 1, 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1}], 1, 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>-1}], 1, 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>''}], 1, 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1, pValue=>undef}], 1, 0), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1, pValue=>undef}], 1, 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1}], 1, 1), CKR_OK );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1}, {type=>1}], 1, 1), CKR_GENERAL_ERROR );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1, pValue=>''}], 1, 0), CKR_OK );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_create_CK_ATTRIBUTE([{type=>1, pValue=>''}], 1, 1), CKR_OK );

    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({}), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({undef=>undef}), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({mechanism=>undef}), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({mechanism=>-1}), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({mechanism=>''}), CKR_ARGUMENTS_BAD );
    myis( Crypt::PKCS11::XSPtr::test_devel_cover_action_init({mechanism=>1, pParameter=>undef}), CKR_ARGUMENTS_BAD );

    myisa_ok( $xs = Crypt::PKCS11::XS->new, 'Crypt::PKCS11::XSPtr' );
    myis( $xs->load('TEST_DEVEL_COVER'), CKR_OK );
    $xs->C_GetInfo($a = {});
    myis( $xs->C_InitToken(1, 1, undef), CKR_ARGUMENTS_BAD, '$xs->C_InitToken(1, 1, undef)' );
    myis( $xs->C_InitToken(1, undef, 1), CKR_OK, '$xs->C_InitToken(1, undef, 1)' );
    myis( $xs->C_InitToken(1, undef, '01234567890123456789012345678901'), CKR_OK, '$xs->C_InitToken(1, undef, 1)' );

    myis( $xs->C_InitPIN(1, undef), CKR_OK, '$xs->C_InitPIN(1, undef)' );
    myis( $xs->C_InitPIN(1, 1), CKR_OK, '$xs->C_InitPIN(1, 1)' );

    myis( $xs->C_SetPIN(1, undef, undef), CKR_OK, '$xs->C_SetPIN(1, undef, undef)' );
    myis( $xs->C_SetPIN(1, 1, undef), CKR_OK, '$xs->C_SetPIN(1, 1, undef)' );
    myis( $xs->C_SetPIN(1, 1, 1), CKR_OK, '$xs->C_SetPIN(1, 1, 1)' );

    {
        local $SIG{__WARN__} = sub {};
        my ($a, $called);
        myis( $xs->C_OpenSession(0, 0, sub { $called = 1; }, $a), CKR_OK, '$xs->C_OpenSession' );
        myok( $called, 'C_OpenSession not called' );
        myis( $xs->C_OpenSession(9999, 0, sub {}, $a), CKR_GENERAL_ERROR, '$xs->C_OpenSession' );
    }

    myis( $xs->C_GetOperationState(1, $a), CKR_OK, '$xs->C_GetOperationState(1, $a)' );
    myis( $xs->C_GetOperationState(9999, $a), CKR_OK, '$xs->C_GetOperationState(1, $a)' );

    {
        local $SIG{__WARN__} = sub {};
        myis( $xs->C_SetOperationState(1, $a, undef, undef), CKR_OK, '$xs->C_SetOperationState(1, $a, undef, undef)' );
    }

    myis( $xs->C_Login(1, 1, undef), CKR_OK, '$xs->C_Loing(1, 1, undef)' );

    myis( $xs->C_GetObjectSize(1, 1, $a), CKR_OK, '$xs->C_GetObjectSize(1, 1, $a)' );

    myis( $xs->C_FindObjects(1, $a = [], 2), CKR_OK, '$xs->C_FindObjects(1, $a = [], 2)' );

    myis( $xs->C_CreateObject(1, $a = [], $b = 0), CKR_OK );
    myis( $xs->C_CreateObject(1, $a = [[]], $b = 0), CKR_ARGUMENTS_BAD );

    myis( $xs->C_CopyObject(1, 1, $a = [], $b = 0), CKR_OK );
    myis( $xs->C_CopyObject(1, 1, $a = [[]], $b = 0), CKR_ARGUMENTS_BAD );

    myis( $xs->C_GetObjectSize(9999, 1, $b), CKR_GENERAL_ERROR );

    myis( $xs->C_GetAttributeValue(1, 1, $a = []), CKR_OK );
    myis( $xs->C_GetAttributeValue(1, 1, $a = [[]]), CKR_ARGUMENTS_BAD );

    myis( $xs->C_SetAttributeValue(1, 1, $a = []), CKR_OK );
    myis( $xs->C_SetAttributeValue(1, 1, $a = [[]]), CKR_ARGUMENTS_BAD );

    myis( $xs->C_FindObjectsInit(1, $a = []), CKR_OK );
    myis( $xs->C_FindObjectsInit(1, $a = [[]]), CKR_ARGUMENTS_BAD );

    myis( $xs->C_EncryptUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_EncryptUpdate(1, $a = '', $b = ''), CKR_OK );
    myis( $xs->C_EncryptFinal(1, $a = ' '), CKR_OK );
    myis( $xs->C_EncryptFinal(1, $a = ''), CKR_OK );
    myis( $xs->C_DecryptUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_DecryptUpdate(1, $a = '', $b = ''), CKR_OK );
    myis( $xs->C_DecryptFinal(1, $a = ' '), CKR_OK );
    myis( $xs->C_DecryptFinal(1, $a = ''), CKR_OK );

    myis( $xs->C_SignRecover(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_SignRecover(1, $a = '', $b = ''), CKR_OK );

    $mech = {};
    myis( $xs->C_EncryptInit(1, $mech, 1), CKR_ARGUMENTS_BAD );
    myis( $xs->C_DecryptInit(1, $mech, 1), CKR_ARGUMENTS_BAD );
    myis( $xs->C_DigestInit(1, $mech), CKR_ARGUMENTS_BAD );
    myis( $xs->C_SignInit(1, $mech, 1), CKR_ARGUMENTS_BAD );
    myis( $xs->C_SignRecoverInit(1, $mech, 1), CKR_ARGUMENTS_BAD );
    myis( $xs->C_VerifyInit(1, $mech, 1), CKR_ARGUMENTS_BAD );
    myis( $xs->C_VerifyRecoverInit(1, $mech, 1), CKR_ARGUMENTS_BAD );

    myis( $xs->C_GenerateKey(1, $mech, [], $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_GenerateKeyPair(1, $mech, [], [], $b, $c), CKR_ARGUMENTS_BAD );
    myis( $xs->C_WrapKey(1, $mech, 1, 1, $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_UnwrapKey(1, $mech, 1, 1, [], $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_DeriveKey(1, $mech, 1, [], $b), CKR_ARGUMENTS_BAD );

    my $mech = Crypt::PKCS11::CK_MECHANISM->new;
    myis( $mech->set_mechanism(CKM_SHA_1), CKR_OK, '$mech->set_mechanism(CKM_SHA_1)' );

    myis( $xs->C_SignRecoverInit(1, $mech->toHash, 1), CKR_OK );
    myis( $xs->C_VerifyRecoverInit(1, $mech->toHash, 1), CKR_OK );

    myis( $xs->C_GenerateKey(1, $mech->toHash, [], $b), CKR_OK );
    myis( $xs->C_GenerateKey(9999, $mech->toHash, [{type => 1, pValue => ''}], $b), CKR_GENERAL_ERROR );
    myis( $xs->C_GenerateKey(1, $mech->toHash, [[]], $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_GenerateKeyPair(1, $mech->toHash, [], [], $b, $c), CKR_OK );
    myis( $xs->C_GenerateKeyPair(1, $mech->toHash, [[]], [], $b, $c), CKR_ARGUMENTS_BAD );
    myis( $xs->C_GenerateKeyPair(1, $mech->toHash, [], [[]], $b, $c), CKR_ARGUMENTS_BAD );
    myis( $xs->C_WrapKey(1, $mech->toHash, 1, 1, $b), CKR_OK );
    myis( $xs->C_WrapKey(1, $mech->toHash, 1, 1, $b = ''), CKR_GENERAL_ERROR );
    myis( $xs->C_WrapKey(9999, $mech->toHash, 1, 1, $b = ''), CKR_GENERAL_ERROR );
    myis( $xs->C_WrapKey(9999, $mech->toHash, 1, 1, $b = ' '), CKR_GENERAL_ERROR );
    myis( $xs->C_UnwrapKey(1, $mech->toHash, 1, 1, [], $b), CKR_OK );
    myis( $xs->C_UnwrapKey(1, $mech->toHash, 1, 1, [[]], $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_UnwrapKey(9999, $mech->toHash, 1, 1, [{type => 1, pValue => ''}], $b), CKR_GENERAL_ERROR );
    myis( $xs->C_DeriveKey(1, $mech->toHash, 1, [], $b), CKR_OK );
    myis( $xs->C_DeriveKey(1, $mech->toHash, 1, [[]], $b), CKR_ARGUMENTS_BAD );
    myis( $xs->C_DeriveKey(9999, $mech->toHash, 1, [{type => 1, pValue => ''}], $b), CKR_GENERAL_ERROR );

    myis( $xs->C_VerifyRecover(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_VerifyRecover(1, $a = '', $b = ''), CKR_OK );

    myis( $xs->C_DigestEncryptUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_DigestEncryptUpdate(1, $a = '', $b = ''), CKR_OK );
    myis( $xs->C_DecryptDigestUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_DecryptDigestUpdate(1, $a = '', $b = ''), CKR_OK );
    myis( $xs->C_SignEncryptUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_SignEncryptUpdate(1, $a = '', $b = ''), CKR_OK );
    myis( $xs->C_DecryptVerifyUpdate(1, $a = '', $b = ' '), CKR_OK );
    myis( $xs->C_DecryptVerifyUpdate(1, $a = '', $b = ''), CKR_OK );

    myis( $xs->C_GenerateRandom(9999, $a, 1), CKR_GENERAL_ERROR );
    myis( $xs->C_GetFunctionStatus(1), CKR_OK );
    myis( $xs->C_CancelFunction(1), CKR_OK );
    myis( $xs->C_WaitForSlotEvent(1, $a), CKR_OK );
}

#{
#    local $SIG{__WARN__} = sub {};
#    my $sub1 = *Crypt::PKCS11::CK_MECHANISMPtr::get_pParameter{CODE};
#    *Crypt::PKCS11::CK_MECHANISMPtr::get_pParameter = sub ($) { return CKR_GENERAL_ERROR; };
#    $mechanism = Crypt::PKCS11::CK_MECHANISM->new;
#    $@ = undef; eval { $mechanism->toHash; };
#    myok( $@, '$mechanism->toHash' );
#    my $sub2 = *Crypt::PKCS11::CK_MECHANISMPtr::get_mechanism{CODE};
#    *Crypt::PKCS11::CK_MECHANISMPtr::get_mechanism = sub ($) { return CKR_GENERAL_ERROR; };
#    $mechanism = Crypt::PKCS11::CK_MECHANISM->new;
#    $@ = undef; eval { $mechanism->toHash; };
#    myok( $@, '$mechanism->toHash' );
#    *Crypt::PKCS11::CK_MECHANISMPtr::get_pParameter = $sub1;
#    *Crypt::PKCS11::CK_MECHANISMPtr::get_mechanism = $sub2;
#}

# Crypt/PKCS11/Attribute.pm

$obj = eval {
    local $SIG{__WARN__} = sub {};
    Crypt::PKCS11::Attribute::new;
};
myok( blessed $obj, 'Crypt::PKCS11::Attribute::new' );
$@ = undef; eval { Crypt::PKCS11::Attribute->new(undef); };
myok( $@, 'Crypt::PKCS11::Attribute->new(undef)' );
myisa_ok( $obj = Crypt::PKCS11::Attribute->new, 'Crypt::PKCS11::Attribute', 'Crypt::PKCS11::Attribute->new' );
myisa_ok( $obj = $obj->new, 'Crypt::PKCS11::Attribute', 'Crypt::PKCS11::Attribute $obj->new' );
$@ = undef; eval { $obj->type; };
myok( $@, '$obj->type' );
$@ = undef; eval { $obj->set; };
myok( $@, '$obj->set' );
$@ = undef; eval { $obj->get; };
myok( $@, '$obj->get' );

# Crypt/PKCS11/Attributes.pm

$obj = eval {
    local $SIG{__WARN__} = sub {};
    Crypt::PKCS11::Attributes::new;
};
myok( blessed $obj, 'Crypt::PKCS11::Attributes::new' );
myisa_ok( $obj = Crypt::PKCS11::Attributes->new, 'Crypt::PKCS11::Attributes', 'Crypt::PKCS11::Attributes->new' );
myisa_ok( $obj = $obj->new, 'Crypt::PKCS11::Attributes', 'Crypt::PKCS11::Attributes $obj->new' );
$@ = undef; eval { $obj->push(undef); };
myok( $@, '$obj->push(undef)' );
$@ = undef; eval { $obj->push(Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->push(Crypt::PKCS11::Attributes->new)' );
myok( $obj->push(Crypt::PKCS11::Attribute->new), '$obj->push(Crypt::PKCS11::Attribute->new)' );
myok( $obj->pop, '$obj->pop' );
$@ = undef; eval { $obj->unshift(undef); };
myok( $@, '$obj->unshift(undef)' );
$@ = undef; eval { $obj->unshift(Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->unshift(Crypt::PKCS11::Attributes->new)' );
myok( $obj->unshift(Crypt::PKCS11::Attribute->new), '$obj->unshift(Crypt::PKCS11::Attribute->new)' );
myok( $obj->all, '$obj->all' );
$@ = undef; eval { $obj->foreach; };
myok( $@, '$obj->foreach' );
myok( $obj->foreach(sub{}), '$obj->foreach(sub{})' );
myok( $obj->shift, '$obj->shift' );
$@ = undef; eval { $obj->fromArray; };
myok( $@, '$obj->fromArray' );
$@ = undef; eval { $obj->fromArray([undef]); };
myok( $@, '$obj->fromArray([undef])' );
$@ = undef; eval { $obj->fromArray([{}]); };
myok( $@, '$obj->fromArray([{}])' );
$@ = undef; eval { $obj->fromArray([{ type => undef }]); };
myok( $@, '$obj->fromArray([{ type => undef }])' );
$@ = undef; eval { $obj->fromArray([{ type => -1, pValue => undef }]); };
myok( $@, '$obj->fromArray([{ type => -1, pValue => undef }])' );
$@ = undef; eval { $obj->fromArray([{ type => -1, pValue => 1 }]); };
myok( $@, '$obj->fromArray([{ type => -1, pValue => 1 }])' );
myok( $obj->fromArray([{
    type => CKA_CLASS,
    pValue => pack(((CK_ULONG_SIZE < 8) ? L : Q), 1),
}]), '$obj->fromArray(...)' );

# Crypt/PKCS11/Object.pm

$obj = eval {
    local $SIG{__WARN__} = sub {};
    Crypt::PKCS11::Object::new(undef, 1);
};
myok( blessed $obj, 'Crypt::PKCS11::Object::new' );
myisa_ok( $obj = Crypt::PKCS11::Object->new(1), 'Crypt::PKCS11::Object', 'Crypt::PKCS11::Object->new' );
myisa_ok( $obj = $obj->new(1), 'Crypt::PKCS11::Object', 'Crypt::PKCS11::Object $obj->new' );
$@ = undef; eval { Crypt::PKCS11::Object->new; };
myok( $@, 'Crypt::PKCS11::Object->new' );
myok( $obj->id, '$obj->id' );

# Crypt/PKCS11/Session.pm

$@ = undef; eval { Crypt::PKCS11::Session->new; };
myok( $@, 'Crypt::PKCS11::Session->new' );
$@ = undef; eval { Crypt::PKCS11::Session->new(Crypt::PKCS11::Attribute->new); };
myok( $@, 'Crypt::PKCS11::Session->new(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { Crypt::PKCS11::Session->new(Crypt::PKCS11::XS->new); };
myok( $@, 'Crypt::PKCS11::Session->new(Crypt::PKCS11::XS->new)' );
$obj = eval {
    local $SIG{__WARN__} = sub {};
    Crypt::PKCS11::Session::new(undef, Crypt::PKCS11::XS->new, 1);
};
myok( blessed $obj, 'Crypt::PKCS11::Session::new' );
myisa_ok( $obj = Crypt::PKCS11::Session->new(Crypt::PKCS11::XS->new, 1), 'Crypt::PKCS11::Session', 'Crypt::PKCS11::Session->new' );
myisa_ok( $obj = $obj->new(Crypt::PKCS11::XS->new, 1), 'Crypt::PKCS11::Session', 'Crypt::PKCS11::Session $obj->new' );
{
    local $SIG{__WARN__} = sub {};
    my $sub;

    myis( $obj->InitPIN, undef, '$obj->InitPIN' );
    myis( $obj->InitPIN(1), undef, '$obj->InitPIN(1)' );
    myis( $obj->InitPIN('abc'), undef, '$obj->InitPIN("abc")' );
    $sub = *Crypt::PKCS11::XSPtr::C_InitPIN{CODE};
    *Crypt::PKCS11::XSPtr::C_InitPIN = sub ($$) { return CKR_OK; };
    myok( $obj->InitPIN, '$obj->InitPIN' );
    *Crypt::PKCS11::XSPtr::C_InitPIN = $sub;

    myis( $obj->SetPIN, undef, '$obj->SetPIN' );
    myis( $obj->SetPIN(1), undef, '$obj->SetPIN(1)' );
    myis( $obj->SetPIN('abc'), undef, '$obj->SetPIN("abc")' );
    myis( $obj->SetPIN(1, 1), undef, '$obj->SetPIN(1, 1)' );
    myis( $obj->SetPIN(1, 'abc'), undef, '$obj->SetPIN(1, "abc")' );
    $sub = *Crypt::PKCS11::XSPtr::C_SetPIN{CODE};
    *Crypt::PKCS11::XSPtr::C_SetPIN = sub ($$) { return CKR_OK; };
    myok( $obj->SetPIN, '$obj->SetPIN' );
    *Crypt::PKCS11::XSPtr::C_SetPIN = $sub;

    $sub = *Crypt::PKCS11::XSPtr::C_CloseSession{CODE};
    *Crypt::PKCS11::XSPtr::C_CloseSession = sub ($) { return CKR_GENERAL_ERROR; };
    myis( $obj->CloseSession, undef, '$obj->CloseSession' );
    *Crypt::PKCS11::XSPtr::C_CloseSession = $sub;

    myis( $obj->GetSessionInfo, undef, '$obj->GetSessionInfo' );
    $sub = *Crypt::PKCS11::XSPtr::C_GetSessionInfo{CODE};
    *Crypt::PKCS11::XSPtr::C_GetSessionInfo = sub ($$$) { $_[2]->{test} = 1; return CKR_OK; };
    myok( scalar (@a = $obj->GetSessionInfo), '$obj->GetSessionInfo' );
    myok( scalar $obj->GetSessionInfo, '$obj->GetSessionInfo' );
    *Crypt::PKCS11::XSPtr::C_GetSessionInfo = sub ($$$) { $_[2]=[]; return CKR_OK; };
    $@ = undef; eval { $obj->GetSessionInfo; };
    myok( $@, '$obj->GetSessionInfo' );
    *Crypt::PKCS11::XSPtr::C_GetSessionInfo = $sub;

    myis( $obj->GetOperationState, undef, '$obj->GetOperationState' );
    $sub = *Crypt::PKCS11::XSPtr::C_GetOperationState{CODE};
    *Crypt::PKCS11::XSPtr::C_GetOperationState = sub ($$$) { return CKR_GENERAL_ERROR; };
    myis( $obj->GetOperationState, undef, '$obj->GetOperationState' );
    *Crypt::PKCS11::XSPtr::C_GetOperationState = sub ($$$) { $_[2]=[]; return CKR_OK; };
    myok( $obj->GetOperationState, '$obj->GetOperationState' );
    *Crypt::PKCS11::XSPtr::C_GetOperationState = $sub;

    myis( $obj->SetOperationState(''), undef, '$obj->SetOperationState("")' );
    myis( $obj->SetOperationState('', Crypt::PKCS11::Object->new(1)), undef, '$obj->SetOperationState("", Crypt::PKCS11::Object->new(1))' );
    myis( $obj->SetOperationState('', Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1)), undef, '$obj->SetOperationState("", Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1))' );
    myis( $obj->SetOperationState('', undef, Crypt::PKCS11::Object->new(1)), undef, '$obj->SetOperationState("", undef, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_SetOperationState{CODE};
    *Crypt::PKCS11::XSPtr::C_SetOperationState = sub ($$$$) { return CKR_OK; };
    myok( $obj->SetOperationState(''), '$obj->SetOperationState("")' );
    *Crypt::PKCS11::XSPtr::C_SetOperationState = $sub;

    myis( $obj->Login(1), undef, '$obj->Login(1)' );

    myis( $obj->Logout, undef, '$obj->Logout' );
    $sub = *Crypt::PKCS11::XSPtr::C_Logout{CODE};
    *Crypt::PKCS11::XSPtr::C_Logout = sub ($$) { return CKR_OK; };
    myok( $obj->Logout, '$obj->Logout' );
    *Crypt::PKCS11::XSPtr::C_Logout = $sub;

    myis( $obj->CreateObject(Crypt::PKCS11::Attributes->new), undef, '$obj->CreateObject(Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_CreateObject{CODE};
    *Crypt::PKCS11::XSPtr::C_CreateObject = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->CreateObject(Crypt::PKCS11::Attributes->new), '$obj->CreateObject(Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_CreateObject = $sub;

    myis( $obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), undef, '$obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_CopyObject{CODE};
    *Crypt::PKCS11::XSPtr::C_CopyObject = sub ($$$$$) { $_[4] = 1; return CKR_OK; };
    myok( $obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), '$obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_CopyObject = $sub;

    myis( $obj->DestroyObject(Crypt::PKCS11::Object->new(1)), undef, '$obj->DestroyObject(Crypt::PKCS11::Object->new(1))' );

    myis( $obj->GetObjectSize(Crypt::PKCS11::Object->new(1)), undef, '$obj->GetObjectSize(Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_GetObjectSize{CODE};
    *Crypt::PKCS11::XSPtr::C_GetObjectSize = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->GetObjectSize(Crypt::PKCS11::Object->new(1)), '$obj->GetObjectSize(Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_GetObjectSize = $sub;

    myis( $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), undef, '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_GetAttributeValue{CODE};
    *Crypt::PKCS11::XSPtr::C_GetAttributeValue = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    $@ = undef; eval { $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new); };
    myok( $@, '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_GetAttributeValue = sub ($$$$) { $_[3] = [{type => CKA_LABEL, pValue => 'abc'}]; return CKR_OK; };
    myok( scalar (@a = $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)), '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    myok( scalar $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_GetAttributeValue = $sub;

    myis( $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), undef, '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_SetAttributeValue{CODE};
    *Crypt::PKCS11::XSPtr::C_SetAttributeValue = sub ($$$$) { return CKR_OK; };
    myok( scalar (@a = $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)), '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    myok( scalar $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_SetAttributeValue = $sub;

    myis( $obj->FindObjectsInit(Crypt::PKCS11::Attributes->new), undef, '$obj->FindObjectsInit(Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_FindObjectsInit{CODE};
    *Crypt::PKCS11::XSPtr::C_FindObjectsInit = sub ($$$) { return CKR_OK; };
    myok( scalar (@a = $obj->FindObjectsInit(Crypt::PKCS11::Attributes->new)), '$obj->FindObjectsInit(Crypt::PKCS11::Attributes->new)' );
    myok( scalar $obj->FindObjectsInit(Crypt::PKCS11::Attributes->new), '$obj->FindObjectsInit(Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_FindObjectsInit = $sub;

    myis( $obj->FindObjects(1), undef, '$obj->FindObjects(1)' );
    $sub = *Crypt::PKCS11::XSPtr::C_FindObjects{CODE};
    *Crypt::PKCS11::XSPtr::C_FindObjects = sub ($$$$) { return CKR_OK; };
    myok( $obj->FindObjects(1), '$obj->FindObjects(1)' );
    *Crypt::PKCS11::XSPtr::C_FindObjects = sub ($$$$) { push(@{$_[2]}, 1, 1); return CKR_OK; };
    myok( scalar (@a = $obj->FindObjects(1)), '$obj->FindObjects(1)' );
    myok( scalar $obj->FindObjects(1), '$obj->FindObjects(1)' );
    *Crypt::PKCS11::XSPtr::C_FindObjects = sub ($$$$) { $_[2] = {}; return CKR_OK; };
    $@ = undef; eval { $obj->FindObjects(1); };
    myok( $@, '$obj->FindObjects(1)' );
    *Crypt::PKCS11::XSPtr::C_FindObjects = $sub;

    myis( $obj->FindObjectsFinal, undef, '$obj->FindObjectsFinal' );
    $sub = *Crypt::PKCS11::XSPtr::C_FindObjectsFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_FindObjectsFinal = sub ($$) { return CKR_OK; };
    myok( $obj->FindObjectsFinal, '$obj->FindObjectsFinal' );
    *Crypt::PKCS11::XSPtr::C_FindObjectsFinal = $sub;

    my $mech = Crypt::PKCS11::CK_MECHANISM->new;
    myis( $mech->set_mechanism(CKM_SHA_1), CKR_OK, '$mech->set_mechanism(CKM_SHA_1)' );
    myis( $mech->get_mechanism($a=1), CKR_OK, '$mech->get_mechanism($a=1)' );

    myis( $obj->EncryptInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->EncryptInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_EncryptInit{CODE};
    *Crypt::PKCS11::XSPtr::C_EncryptInit = sub ($$) { return CKR_OK; };
    myok( $obj->EncryptInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->EncryptInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_EncryptInit = $sub;

    myis( $obj->Encrypt(''), undef, '$obj->Encrypt("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_Encrypt{CODE};
    *Crypt::PKCS11::XSPtr::C_Encrypt = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->Encrypt(''), '$obj->Encrypt("")' );
    *Crypt::PKCS11::XSPtr::C_Encrypt = $sub;

    myis( $obj->EncryptUpdate(''), undef, '$obj->EncryptUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_EncryptUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_EncryptUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->EncryptUpdate(''), '$obj->EncryptUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_EncryptUpdate = $sub;

    myis( $obj->EncryptFinal, undef, '$obj->EncryptFinal' );
    $sub = *Crypt::PKCS11::XSPtr::C_EncryptFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_EncryptFinal = sub ($$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->EncryptFinal, '$obj->EncryptFinal' );
    *Crypt::PKCS11::XSPtr::C_EncryptFinal = $sub;

    myis( $obj->DecryptInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->DecryptInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_DecryptInit{CODE};
    *Crypt::PKCS11::XSPtr::C_DecryptInit = sub ($$) { return CKR_OK; };
    myok( $obj->DecryptInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->DecryptInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_DecryptInit = $sub;

    myis( $obj->Decrypt(''), undef, '$obj->Decrypt("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_Decrypt{CODE};
    *Crypt::PKCS11::XSPtr::C_Decrypt = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->Decrypt(''), '$obj->Decrypt("")' );
    *Crypt::PKCS11::XSPtr::C_Decrypt = $sub;

    myis( $obj->DecryptUpdate(''), undef, '$obj->DecryptUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_DecryptUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_DecryptUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->DecryptUpdate(''), '$obj->DecryptUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_DecryptUpdate = $sub;

    myis( $obj->DecryptFinal, undef, '$obj->DecryptFinal' );
    $sub = *Crypt::PKCS11::XSPtr::C_DecryptFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_DecryptFinal = sub ($$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->DecryptFinal, '$obj->DecryptFinal' );
    *Crypt::PKCS11::XSPtr::C_DecryptFinal = $sub;

    myis( $obj->DigestInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->DigestInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_DigestInit{CODE};
    *Crypt::PKCS11::XSPtr::C_DigestInit = sub ($$) { return CKR_OK; };
    myok( $obj->DigestInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->DigestInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_DigestInit = $sub;

    myis( $obj->Digest(''), undef, '$obj->Digest("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_Digest{CODE};
    *Crypt::PKCS11::XSPtr::C_Digest = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->Digest(''), '$obj->Digest("")' );
    *Crypt::PKCS11::XSPtr::C_Digest = $sub;

    myis( $obj->DigestUpdate(''), undef, '$obj->DigestUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_DigestUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_DigestUpdate = sub ($$$$) { return CKR_OK; };
    myok( $obj->DigestUpdate(''), '$obj->DigestUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_DigestUpdate = $sub;

    myis( $obj->DigestKey(Crypt::PKCS11::Object->new(1)), undef, '$obj->DigestKey(Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_DigestKey{CODE};
    *Crypt::PKCS11::XSPtr::C_DigestKey = sub ($$$$) { return CKR_OK; };
    myok( $obj->DigestKey(Crypt::PKCS11::Object->new(1)), '$obj->DigestKey(Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_DigestKey = $sub;

    myis( $obj->DigestFinal, undef, '$obj->DigestFinal' );
    $sub = *Crypt::PKCS11::XSPtr::C_DigestFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_DigestFinal = sub ($$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->DigestFinal, '$obj->DigestFinal' );
    *Crypt::PKCS11::XSPtr::C_DigestFinal = $sub;

    myis( $obj->SignInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->SignInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignInit{CODE};
    *Crypt::PKCS11::XSPtr::C_SignInit = sub ($$) { return CKR_OK; };
    myok( $obj->SignInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->SignInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_SignInit = $sub;

    myis( $obj->Sign(''), undef, '$obj->Sign("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_Sign{CODE};
    *Crypt::PKCS11::XSPtr::C_Sign = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->Sign(''), '$obj->Sign("")' );
    *Crypt::PKCS11::XSPtr::C_Sign = $sub;

    myis( $obj->SignUpdate(''), undef, '$obj->SignUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_SignUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->SignUpdate(''), '$obj->SignUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_SignUpdate = $sub;

    myis( $obj->SignFinal, undef, '$obj->SignFinal' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_SignFinal = sub ($$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->SignFinal, '$obj->SignFinal' );
    *Crypt::PKCS11::XSPtr::C_SignFinal = $sub;

    myis( $obj->SignRecoverInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->SignRecoverInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignRecoverInit{CODE};
    *Crypt::PKCS11::XSPtr::C_SignRecoverInit = sub ($$) { return CKR_OK; };
    myok( $obj->SignRecoverInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->SignRecoverInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_SignRecoverInit = $sub;

    myis( $obj->SignRecover(''), undef, '$obj->SignRecover("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignRecover{CODE};
    *Crypt::PKCS11::XSPtr::C_SignRecover = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->SignRecover(''), '$obj->SignRecover("")' );
    *Crypt::PKCS11::XSPtr::C_SignRecover = $sub;

    myis( $obj->VerifyInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->VerifyInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_VerifyInit{CODE};
    *Crypt::PKCS11::XSPtr::C_VerifyInit = sub ($$) { return CKR_OK; };
    myok( $obj->VerifyInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->VerifyInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_VerifyInit = $sub;

    myis( $obj->Verify('', ''), undef, '$obj->Verify("", "")' );
    $sub = *Crypt::PKCS11::XSPtr::C_Verify{CODE};
    *Crypt::PKCS11::XSPtr::C_Verify = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->Verify('', ''), '$obj->Verify("", "")' );
    *Crypt::PKCS11::XSPtr::C_Verify = $sub;

    myis( $obj->VerifyUpdate(''), undef, '$obj->VerifyUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_VerifyUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_VerifyUpdate = sub ($$$$) { return CKR_OK; };
    myok( $obj->VerifyUpdate(''), '$obj->VerifyUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_VerifyUpdate = $sub;

    myis( $obj->VerifyFinal(''), undef, '$obj->VerifyFinal("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_VerifyFinal{CODE};
    *Crypt::PKCS11::XSPtr::C_VerifyFinal = sub ($$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->VerifyFinal(''), '$obj->VerifyFinal("")' );
    *Crypt::PKCS11::XSPtr::C_VerifyFinal = $sub;

    myis( $obj->VerifyRecoverInit($mech, Crypt::PKCS11::Object->new(1)), undef, '$obj->VerifyRecoverInit($mech, Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_VerifyRecoverInit{CODE};
    *Crypt::PKCS11::XSPtr::C_VerifyRecoverInit = sub ($$) { return CKR_OK; };
    myok( $obj->VerifyRecoverInit($mech, Crypt::PKCS11::Object->new(1)), '$obj->VerifyRecoverInit($mech, Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_VerifyRecoverInit = $sub;

    myis( $obj->VerifyRecover(''), undef, '$obj->VerifyRecover("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_VerifyRecover{CODE};
    *Crypt::PKCS11::XSPtr::C_VerifyRecover = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->VerifyRecover(''), '$obj->VerifyRecover("")' );
    *Crypt::PKCS11::XSPtr::C_VerifyRecover = $sub;

    myis( $obj->DigestEncryptUpdate(''), undef, '$obj->DigestEncryptUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_DigestEncryptUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_DigestEncryptUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->DigestEncryptUpdate(''), '$obj->DigestEncryptUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_DigestEncryptUpdate = $sub;

    myis( $obj->DecryptDigestUpdate(''), undef, '$obj->DecryptDigestUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_DecryptDigestUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_DecryptDigestUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->DecryptDigestUpdate(''), '$obj->DecryptDigestUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_DecryptDigestUpdate = $sub;

    myis( $obj->SignEncryptUpdate(''), undef, '$obj->SignEncryptUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_SignEncryptUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_SignEncryptUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->SignEncryptUpdate(''), '$obj->SignEncryptUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_SignEncryptUpdate = $sub;

    myis( $obj->DecryptVerifyUpdate(''), undef, '$obj->DecryptVerifyUpdate("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_DecryptVerifyUpdate{CODE};
    *Crypt::PKCS11::XSPtr::C_DecryptVerifyUpdate = sub ($$$$) { $_[3] = 1; return CKR_OK; };
    myok( $obj->DecryptVerifyUpdate(''), '$obj->DecryptVerifyUpdate("")' );
    *Crypt::PKCS11::XSPtr::C_DecryptVerifyUpdate = $sub;

    myis( $obj->GenerateKey($mech, Crypt::PKCS11::Attributes->new), undef, '$obj->GenerateKey($mech, Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_GenerateKey{CODE};
    *Crypt::PKCS11::XSPtr::C_GenerateKey = sub ($$$$$) { $_[4] = 1; return CKR_OK; };
    myok( $obj->GenerateKey($mech, Crypt::PKCS11::Attributes->new), '$obj->GenerateKey($mech, Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_GenerateKey = $sub;

    myis( $obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new), CKR_GENERAL_ERROR, '$obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_GenerateKeyPair{CODE};
    *Crypt::PKCS11::XSPtr::C_GenerateKeyPair = sub ($$$$$$$) { $_[5] = 1; $_[6] = 1; return CKR_OK; };
    myok( scalar (@a = $obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new)), '$obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new)' );
    myok( scalar $obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new), '$obj->GenerateKeyPair($mech, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_GenerateKeyPair = $sub;

    myis( $obj->WrapKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1)), undef, '$obj->WrapKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1))' );
    $sub = *Crypt::PKCS11::XSPtr::C_WrapKey{CODE};
    *Crypt::PKCS11::XSPtr::C_WrapKey = sub ($$$$$$) { $_[5] = 1; return CKR_OK; };
    myok( $obj->WrapKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1)), '$obj->WrapKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Object->new(1))' );
    *Crypt::PKCS11::XSPtr::C_WrapKey = $sub;

    myis( $obj->UnwrapKey($mech, Crypt::PKCS11::Object->new(1), '', Crypt::PKCS11::Attributes->new), undef, '$obj->UnwrapKey($mech, Crypt::PKCS11::Object->new(1), "", Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_UnwrapKey{CODE};
    *Crypt::PKCS11::XSPtr::C_UnwrapKey = sub ($$$$$$$) { $_[6] = 1; return CKR_OK; };
    myok( $obj->UnwrapKey($mech, Crypt::PKCS11::Object->new(1), '', Crypt::PKCS11::Attributes->new), '$obj->UnwrapKey($mech, Crypt::PKCS11::Object->new(1), "", Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_UnwrapKey = $sub;

    myis( $obj->DeriveKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), undef, '$obj->DeriveKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    $sub = *Crypt::PKCS11::XSPtr::C_DeriveKey{CODE};
    *Crypt::PKCS11::XSPtr::C_DeriveKey = sub ($$$$$$) { $_[5] = 1; return CKR_OK; };
    myok( $obj->DeriveKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new), '$obj->DeriveKey($mech, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attributes->new)' );
    *Crypt::PKCS11::XSPtr::C_DeriveKey = $sub;

    myis( $obj->SeedRandom(''), undef, '$obj->SeedRandom("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_SeedRandom{CODE};
    *Crypt::PKCS11::XSPtr::C_SeedRandom = sub ($$$) { return CKR_OK; };
    myok( $obj->SeedRandom(''), '$obj->SeedRandom("")' );
    *Crypt::PKCS11::XSPtr::C_SeedRandom = $sub;

    myis( $obj->GenerateRandom(''), undef, '$obj->GenerateRandom("")' );
    $sub = *Crypt::PKCS11::XSPtr::C_GenerateRandom{CODE};
    *Crypt::PKCS11::XSPtr::C_GenerateRandom = sub ($$$$) { $_[2] = 1; return CKR_OK; };
    myok( $obj->GenerateRandom(''), '$obj->GenerateRandom("")' );
    *Crypt::PKCS11::XSPtr::C_GenerateRandom = $sub;

    myis( $obj->GetFunctionStatus, CKR_GENERAL_ERROR, '$obj->GetFunctionStatus' );
    myis( $obj->CancelFunction, CKR_GENERAL_ERROR, '$obj->CancelFunction' );
}

$@ = undef; eval { $obj->InitPIN(''); };
myok( $@, '$obj->InitPIN("")' );
$@ = undef; eval { $obj->SetPIN(''); };
myok( $@, '$obj->SetPIN("")' );
$@ = undef; eval { $obj->SetPIN('a', ''); };
myok( $@, '$obj->SetPIN("a", "")' );
$@ = undef; eval { $obj->SetOperationState; };
myok( $@, '$obj->SetOperationState' );
$@ = undef; eval { $obj->SetOperationState(1, 1); };
myok( $@, '$obj->SetOperationState(1, 1)' );
$@ = undef; eval { $obj->SetOperationState(1, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SetOperationState(1, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SetOperationState(1, Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->SetOperationState(1, Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->SetOperationState(1, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SetOperationState(1, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Login; };
myok( $@, '$obj->Login' );
$@ = undef; eval { $obj->CreateObject; };
myok( $@, '$obj->CreateObject' );
$@ = undef; eval { $obj->CreateObject(1); };
myok( $@, '$obj->CreateObject(1)' );
$@ = undef; eval { $obj->CreateObject(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->CreateObject(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->CreateObject(Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->CreateObject(Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->CreateObject(Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->CreateObject(Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->CreateObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->CreateObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->CopyObject; };
myok( $@, '$obj->CopyObject' );
$@ = undef; eval { $obj->CopyObject(1); };
myok( $@, '$obj->CopyObject(1)' );
$@ = undef; eval { $obj->CopyObject(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->CopyObject(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->CopyObject(Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->CopyObject(Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->CopyObject(Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->CopyObject(Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->CopyObject(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->DestroyObject; };
myok( $@, '$obj->DestroyObject' );
$@ = undef; eval { $obj->DestroyObject(1); };
myok( $@, '$obj->DestroyObject(1)' );
$@ = undef; eval { $obj->DestroyObject(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DestroyObject(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GetObjectSize; };
myok( $@, '$obj->GetObjectSize' );
$@ = undef; eval { $obj->GetObjectSize(1); };
myok( $@, '$obj->GetObjectSize(1)' );
$@ = undef; eval { $obj->GetObjectSize(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GetObjectSize(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GetAttributeValue; };
myok( $@, '$obj->GetAttributeValue' );
$@ = undef; eval { $obj->GetAttributeValue(1); };
myok( $@, '$obj->GetAttributeValue(1)' );
$@ = undef; eval { $obj->GetAttributeValue(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GetAttributeValue(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SetAttributeValue; };
myok( $@, '$obj->SetAttributeValue' );
$@ = undef; eval { $obj->SetAttributeValue(1); };
myok( $@, '$obj->SetAttributeValue(1)' );
$@ = undef; eval { $obj->SetAttributeValue(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SetAttributeValue(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SetAttributeValue(Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->FindObjectsInit; };
myok( $@, '$obj->FindObjectsInit' );
$@ = undef; eval { $obj->FindObjectsInit(1); };
myok( $@, '$obj->FindObjectsInit(1)' );
$@ = undef; eval { $obj->FindObjectsInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->FindObjectsInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->FindObjects; };
myok( $@, '$obj->FindObjects' );
$@ = undef; eval { $obj->EncryptInit; };
myok( $@, '$obj->EncryptInit' );
$@ = undef; eval { $obj->EncryptInit(1); };
myok( $@, '$obj->EncryptInit(1)' );
$@ = undef; eval { $obj->EncryptInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->EncryptInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->EncryptInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Encrypt; };
myok( $@, '$obj->Encrypt' );
$@ = undef; eval { $obj->EncryptUpdate; };
myok( $@, '$obj->EncryptUpdate' );
$@ = undef; eval { $obj->DecryptInit; };
myok( $@, '$obj->DecryptInit' );
$@ = undef; eval { $obj->DecryptInit(1); };
myok( $@, '$obj->DecryptInit(1)' );
$@ = undef; eval { $obj->DecryptInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DecryptInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DecryptInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Decrypt; };
myok( $@, '$obj->Decrypt' );
$@ = undef; eval { $obj->DecryptUpdate; };
myok( $@, '$obj->DecryptUpdate' );
$@ = undef; eval { $obj->DigestInit; };
myok( $@, '$obj->DigestInit' );
$@ = undef; eval { $obj->DigestInit(1); };
myok( $@, '$obj->DigestInit(1)' );
$@ = undef; eval { $obj->DigestInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DigestInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Digest; };
myok( $@, '$obj->Digest' );
$@ = undef; eval { $obj->DigestUpdate; };
myok( $@, '$obj->DigestUpdate' );
$@ = undef; eval { $obj->DigestKey; };
myok( $@, '$obj->DigestKey' );
$@ = undef; eval { $obj->DigestKey(1); };
myok( $@, '$obj->DigestKey(1)' );
$@ = undef; eval { $obj->DigestKey(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DigestKey(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SignInit; };
myok( $@, '$obj->SignInit' );
$@ = undef; eval { $obj->SignInit(1); };
myok( $@, '$obj->SignInit(1)' );
$@ = undef; eval { $obj->SignInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SignInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SignInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Sign; };
myok( $@, '$obj->Sign' );
$@ = undef; eval { $obj->SignUpdate; };
myok( $@, '$obj->SignUpdate' );
$@ = undef; eval { $obj->SignRecoverInit; };
myok( $@, '$obj->SignRecoverInit' );
$@ = undef; eval { $obj->SignRecoverInit(1); };
myok( $@, '$obj->SignRecoverInit(1)' );
$@ = undef; eval { $obj->SignRecoverInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SignRecoverInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->SignRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SignRecover; };
myok( $@, '$obj->SignRecover' );
$@ = undef; eval { $obj->VerifyInit; };
myok( $@, '$obj->VerifyInit' );
$@ = undef; eval { $obj->VerifyInit(1); };
myok( $@, '$obj->VerifyInit(1)' );
$@ = undef; eval { $obj->VerifyInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->VerifyInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->VerifyInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->Verify; };
myok( $@, '$obj->Verify' );
$@ = undef; eval { $obj->Verify(1); };
myok( $@, '$obj->Verify(1)' );
$@ = undef; eval { $obj->VerifyUpdate; };
myok( $@, '$obj->VerifyUpdate' );
$@ = undef; eval { $obj->VerifyFinal; };
myok( $@, '$obj->VerifyFinal' );
$@ = undef; eval { $obj->VerifyRecoverInit; };
myok( $@, '$obj->VerifyRecoverInit' );
$@ = undef; eval { $obj->VerifyRecoverInit(1); };
myok( $@, '$obj->VerifyRecoverInit(1)' );
$@ = undef; eval { $obj->VerifyRecoverInit(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->VerifyRecoverInit(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->VerifyRecoverInit(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->VerifyRecover; };
myok( $@, '$obj->VerifyRecover' );
$@ = undef; eval { $obj->DigestEncryptUpdate; };
myok( $@, '$obj->DigestEncryptUpdate' );
$@ = undef; eval { $obj->DecryptDigestUpdate; };
myok( $@, '$obj->DecryptDigestUpdate' );
$@ = undef; eval { $obj->SignEncryptUpdate; };
myok( $@, '$obj->SignEncryptUpdate' );
$@ = undef; eval { $obj->DecryptVerifyUpdate; };
myok( $@, '$obj->DecryptVerifyUpdate' );
$@ = undef; eval { $obj->GenerateKey; };
myok( $@, '$obj->GenerateKey' );
$@ = undef; eval { $obj->GenerateKey(1); };
myok( $@, '$obj->GenerateKey(1)' );
$@ = undef; eval { $obj->GenerateKey(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GenerateKey(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GenerateKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GenerateKeyPair; };
myok( $@, '$obj->GenerateKeyPair' );
$@ = undef; eval { $obj->GenerateKeyPair(1); };
myok( $@, '$obj->GenerateKeyPair(1)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new, 1); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new, 1)' );
$@ = undef; eval { $obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->GenerateKeyPair(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attributes->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->WrapKey; };
myok( $@, '$obj->WrapKey' );
$@ = undef; eval { $obj->WrapKey(1); };
myok( $@, '$obj->WrapKey(1)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->WrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->UnwrapKey; };
myok( $@, '$obj->UnwrapKey' );
$@ = undef; eval { $obj->UnwrapKey(1); };
myok( $@, '$obj->UnwrapKey(1)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1, 1); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1, 1)' );
$@ = undef; eval { $obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->UnwrapKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->DeriveKey; };
myok( $@, '$obj->DeriveKey' );
$@ = undef; eval { $obj->DeriveKey(1); };
myok( $@, '$obj->DeriveKey(1)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, 1); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, 1)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1)); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1))' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), 1)' );
$@ = undef; eval { $obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new); };
myok( $@, '$obj->DeriveKey(Crypt::PKCS11::CK_MECHANISM->new, Crypt::PKCS11::Object->new(1), Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->SeedRandom; };
myok( $@, '$obj->SeedRandom' );
$@ = undef; eval { $obj->GenerateRandom; };
myok( $@, '$obj->GenerateRandom' );

delete $obj->{session};
$@ = undef; eval { $obj->InitPIN; };
myok( $@, '$obj->InitPIN' );
$@ = undef; eval { $obj->SetPIN; };
myok( $@, '$obj->SetPIN' );
$@ = undef; eval { $obj->CloseSession; };
myok( $@, '$obj->CloseSession' );
$@ = undef; eval { $obj->GetSessionInfo; };
myok( $@, '$obj->GetSessionInfo' );
$@ = undef; eval { $obj->GetOperationState; };
myok( $@, '$obj->GetOperationState' );
$@ = undef; eval { $obj->SetOperationState; };
myok( $@, '$obj->SetOperationState' );
$@ = undef; eval { $obj->Login; };
myok( $@, '$obj->Login' );
$@ = undef; eval { $obj->Logout; };
myok( $@, '$obj->Logout' );
$@ = undef; eval { $obj->CreateObject; };
myok( $@, '$obj->CreateObject' );
$@ = undef; eval { $obj->CopyObject; };
myok( $@, '$obj->CopyObject' );
$@ = undef; eval { $obj->DestroyObject; };
myok( $@, '$obj->DestroyObject' );
$@ = undef; eval { $obj->GetObjectSize; };
myok( $@, '$obj->GetObjectSize' );
$@ = undef; eval { $obj->GetAttributeValue; };
myok( $@, '$obj->GetAttributeValue' );
$@ = undef; eval { $obj->SetAttributeValue; };
myok( $@, '$obj->SetAttributeValue' );
$@ = undef; eval { $obj->FindObjectsInit; };
myok( $@, '$obj->FindObjectsInit' );
$@ = undef; eval { $obj->FindObjects; };
myok( $@, '$obj->FindObjects' );
$@ = undef; eval { $obj->FindObjectsFinal; };
myok( $@, '$obj->FindObjectsFinal' );
$@ = undef; eval { $obj->EncryptInit; };
myok( $@, '$obj->EncryptInit' );
$@ = undef; eval { $obj->Encrypt; };
myok( $@, '$obj->Encrypt' );
$@ = undef; eval { $obj->EncryptUpdate; };
myok( $@, '$obj->EncryptUpdate' );
$@ = undef; eval { $obj->EncryptFinal; };
myok( $@, '$obj->EncryptFinal' );
$@ = undef; eval { $obj->DecryptInit; };
myok( $@, '$obj->DecryptInit' );
$@ = undef; eval { $obj->Decrypt; };
myok( $@, '$obj->Decrypt' );
$@ = undef; eval { $obj->DecryptUpdate; };
myok( $@, '$obj->DecryptUpdate' );
$@ = undef; eval { $obj->DecryptFinal; };
myok( $@, '$obj->DecryptFinal' );
$@ = undef; eval { $obj->DigestInit; };
myok( $@, '$obj->DigestInit' );
$@ = undef; eval { $obj->Digest; };
myok( $@, '$obj->Digest' );
$@ = undef; eval { $obj->DigestUpdate; };
myok( $@, '$obj->DigestUpdate' );
$@ = undef; eval { $obj->DigestKey; };
myok( $@, '$obj->DigestKey' );
$@ = undef; eval { $obj->DigestFinal; };
myok( $@, '$obj->DigestFinal' );
$@ = undef; eval { $obj->SignInit; };
myok( $@, '$obj->SignInit' );
$@ = undef; eval { $obj->Sign; };
myok( $@, '$obj->Sign' );
$@ = undef; eval { $obj->SignUpdate; };
myok( $@, '$obj->SignUpdate' );
$@ = undef; eval { $obj->SignFinal; };
myok( $@, '$obj->SignFinal' );
$@ = undef; eval { $obj->SignRecoverInit; };
myok( $@, '$obj->SignRecoverInit' );
$@ = undef; eval { $obj->SignRecover; };
myok( $@, '$obj->SignRecover' );
$@ = undef; eval { $obj->VerifyInit; };
myok( $@, '$obj->VerifyInit' );
$@ = undef; eval { $obj->Verify; };
myok( $@, '$obj->Verify' );
$@ = undef; eval { $obj->VerifyUpdate; };
myok( $@, '$obj->VerifyUpdate' );
$@ = undef; eval { $obj->VerifyFinal; };
myok( $@, '$obj->VerifyFinal' );
$@ = undef; eval { $obj->VerifyRecoverInit; };
myok( $@, '$obj->VerifyRecoverInit' );
$@ = undef; eval { $obj->VerifyRecover; };
myok( $@, '$obj->VerifyRecover' );
$@ = undef; eval { $obj->DigestEncryptUpdate; };
myok( $@, '$obj->DigestEncryptUpdate' );
$@ = undef; eval { $obj->DecryptDigestUpdate; };
myok( $@, '$obj->DecryptDigestUpdate' );
$@ = undef; eval { $obj->SignEncryptUpdate; };
myok( $@, '$obj->SignEncryptUpdate' );
$@ = undef; eval { $obj->DecryptVerifyUpdate; };
myok( $@, '$obj->DecryptVerifyUpdate' );
$@ = undef; eval { $obj->GenerateKey; };
myok( $@, '$obj->GenerateKey' );
$@ = undef; eval { $obj->GenerateKeyPair; };
myok( $@, '$obj->GenerateKeyPair' );
$@ = undef; eval { $obj->WrapKey; };
myok( $@, '$obj->WrapKey' );
$@ = undef; eval { $obj->UnwrapKey; };
myok( $@, '$obj->UnwrapKey' );
$@ = undef; eval { $obj->DeriveKey; };
myok( $@, '$obj->DeriveKey' );
$@ = undef; eval { $obj->SeedRandom; };
myok( $@, '$obj->SeedRandom' );
$@ = undef; eval { $obj->GenerateRandom; };
myok( $@, '$obj->GenerateRandom' );
$@ = undef; eval { $obj->GetFunctionStatus; };
myok( $@, '$obj->GetFunctionStatus' );
$@ = undef; eval { $obj->CancelFunction; };
myok( $@, '$obj->CancelFunction' );

# Crypt/PKCS11/Attribute/AttributeArray.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::AttributeArray->new, 'Crypt::PKCS11::Attribute::AttributeArray', 'Crypt::PKCS11::Attribute::AttributeArray->new' );
$@ = undef; eval { $obj->push(undef); };
myok( $@, '$obj->push(undef)' );
$@ = undef; eval { $obj->push(Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->push(Crypt::PKCS11::Attributes->new)' );
myok( $obj->push(Crypt::PKCS11::Attribute->new), '$obj->push(Crypt::PKCS11::Attribute->new)' );
myok( $obj->pop, '$obj->pop' );
$@ = undef; eval { $obj->unshift(undef); };
myok( $@, '$obj->unshift(undef)' );
$@ = undef; eval { $obj->unshift(Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->unshift(Crypt::PKCS11::Attributes->new)' );
myok( $obj->unshift(Crypt::PKCS11::Attribute::Class->new->set(1)), '$obj->unshift(Crypt::PKCS11::Attribute->new)' );
$@ = undef; eval { $obj->foreach; };
myok( $@, '$obj->foreach' );
myok( $obj->foreach(sub{}), '$obj->foreach(sub{})' );
myok( $obj->toArray, '$obj->toArray' );
myok( $obj->shift, '$obj->shift' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set(Crypt::PKCS11::Attributes->new); };
myok( $@, '$obj->set(Crypt::PKCS11::Attributes->new)' );
myok( $obj->set(Crypt::PKCS11::Attribute::Class->new->set(1)), '$obj->set' );
myok( $obj->pValue, '$obj->pValue' );

# Crypt/PKCS11/Attribute/ByteArray.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::ByteArray->new, 'Crypt::PKCS11::Attribute::ByteArray', 'Crypt::PKCS11::Attribute::ByteArray->new' );
$@ = undef; eval { $obj->set; };
myok( $@, '$obj->set' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set(''); };
myok( $@, '$obj->set("")' );
$@ = undef; eval { $obj->set(-1); };
myok( $@, '$obj->set(-1)' );
$@ = undef; eval { $obj->set(666); };
myok( $@, '$obj->set(666)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/CK_BBOOL.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::CK_BBOOL->new, 'Crypt::PKCS11::Attribute::CK_BBOOL', 'Crypt::PKCS11::Attribute::CK_BBOOL->new' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(0), '$obj->set(0)' );
myis( $obj->get, 0, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/CK_BYTE.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::CK_BYTE->new, 'Crypt::PKCS11::Attribute::CK_BYTE', 'Crypt::PKCS11::Attribute::CK_BYTE->new' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set(''); };
myok( $@, '$obj->set("")' );
$@ = undef; eval { $obj->set(-1); };
myok( $@, '$obj->set(-1)' );
$@ = undef; eval { $obj->set(666); };
myok( $@, '$obj->set(666)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/CK_DATE.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::CK_DATE->new, 'Crypt::PKCS11::Attribute::CK_DATE', 'Crypt::PKCS11::Attribute::CK_DATE->new' );
$@ = undef; eval { $obj->set; };
myok( $@, '$obj->set' );
$@ = undef; eval { $obj->set(1); };
myok( $@, '$obj->set(1)' );
$@ = undef; eval { $obj->set(1, 1); };
myok( $@, '$obj->set(1, 1)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(2000, 1, 1), '$obj->set(2000, 1, 1)' );
myok( $obj->set('2000-01-01'), '$obj->set("2000-01-01")' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/CK_ULONG.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::CK_ULONG->new, 'Crypt::PKCS11::Attribute::CK_ULONG', 'Crypt::PKCS11::Attribute::CK_ULONG->new' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set(''); };
myok( $@, '$obj->set("")' );
$@ = undef; eval { $obj->set(-1); };
myok( $@, '$obj->set(-1)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/RFC2279string.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::RFC2279string->new, 'Crypt::PKCS11::Attribute::RFC2279string', 'Crypt::PKCS11::Attribute::RFC2279string->new' );
$@ = undef; eval { $obj->set; };
myok( $@, '$obj->set' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set('abc'), '$obj->set("abc")' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/UlongArray.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::UlongArray->new, 'Crypt::PKCS11::Attribute::UlongArray', 'Crypt::PKCS11::Attribute::UlongArray->new' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set(''); };
myok( $@, '$obj->set("")' );
$@ = undef; eval { $obj->set(-1); };
myok( $@, '$obj->set(-1)' );
myis( $obj->get, undef, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( $obj->get, '$obj->get' );

# Crypt/PKCS11/Attribute/Value.pm

myisa_ok( $obj = Crypt::PKCS11::Attribute::Value->new, 'Crypt::PKCS11::Attribute::Value', 'Crypt::PKCS11::Attribute::Value->new' );
$@ = undef; eval { $obj->set(undef); };
myok( $@, '$obj->set(undef)' );
$@ = undef; eval { $obj->set('', ''); };
myok( $@, '$obj->set("", "")' );
$@ = undef; eval { $obj->set(-1); };
myok( $@, '$obj->set(-1)' );
$@ = undef; eval { $obj->set(666); };
myok( $@, '$obj->set(666)' );
myis( scalar $obj->get, undef, '$obj->get' );
myis( scalar (@a = $obj->get), 0, '$obj->get' );
myok( $obj->set(1), '$obj->set(1)' );
myok( scalar $obj->get, '$obj->get' );
myisa_ok( $obj = Crypt::PKCS11::Attribute::Value->new, 'Crypt::PKCS11::Attribute::Value', 'Crypt::PKCS11::Attribute::Value->new' );
$@ = undef; eval { $obj->set; };
myok( $@, '$obj->set' );
myis( scalar $obj->get, undef, '$obj->get' );
myok( $obj->set('abc'), '$obj->set("abc")' );
myok( scalar $obj->get, '$obj->get' );
@a = $obj->get;
myok( scalar @a, '@a = $obj->get' );

# structs

{
    local $SIG{__WARN__} = sub {};
    myok( defined Crypt::PKCS11::CK_VERSION->new->major, 'Crypt::PKCS11::CK_VERSION->new->major' );
    myok( defined Crypt::PKCS11::CK_VERSION->new->minor, 'Crypt::PKCS11::CK_VERSION->new->minor' );
    myok( defined Crypt::PKCS11::CK_MECHANISM->new->mechanism, 'Crypt::PKCS11::CK_MECHANISM->new->mechanism' );
    myis( Crypt::PKCS11::CK_MECHANISM->new->pParameter, undef, 'Crypt::PKCS11::CK_MECHANISM->new->pParameter' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->hashAlg, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->hashAlg' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->mgf, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->mgf' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->source, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->source' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->pSourceData, undef, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->pSourceData' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->hashAlg, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->hashAlg' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->mgf, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->mgf' );
    myok( defined Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->sLen, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->sLen' );
    myok( defined Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->pSharedData, undef, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->pSharedData' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pSharedData, undef, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pSharedData' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->hPrivateData, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->hPrivateData' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pPublicData2, undef, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->pPublicData2' );
    myok( defined Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pSharedData, undef, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pSharedData' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->hPrivateData, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->hPrivateData' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pPublicData2, undef, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->pPublicData2' );
    myok( defined Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->publicKey, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->publicKey' );
    myok( defined Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->pOtherInfo, undef, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->pOtherInfo' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pOtherInfo, undef, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pOtherInfo' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->hPrivateData, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->hPrivateData' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pPublicData2, undef, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->pPublicData2' );
    myok( defined Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->kdf, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->kdf' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pOtherInfo, undef, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pOtherInfo' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->hPrivateData, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->hPrivateData' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pPublicData2, undef, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->pPublicData2' );
    myok( defined Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->publicKey, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->publicKey' );
    myok( defined Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->isSender, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->isSender' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pRandomA, undef, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pRandomA' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pRandomB, undef, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pRandomB' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->pPublicData' );
    myok( defined Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->ulEffectiveBits, 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->ulEffectiveBits' );
    myok( defined Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->iv, 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->iv' );
    myok( defined Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new->ulEffectiveBits, 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new->ulEffectiveBits' );
    myok( defined Crypt::PKCS11::CK_RC5_PARAMS->new->ulWordsize, 'Crypt::PKCS11::CK_RC5_PARAMS->new->ulWordsize' );
    myok( defined Crypt::PKCS11::CK_RC5_PARAMS->new->ulRounds, 'Crypt::PKCS11::CK_RC5_PARAMS->new->ulRounds' );
    myok( defined Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->ulWordsize, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->ulWordsize' );
    myok( defined Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->ulRounds, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->ulRounds' );
    myis( Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->pIv, undef, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->pIv' );
    myok( defined Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->ulWordsize, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->ulWordsize' );
    myok( defined Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->ulRounds, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->ulRounds' );
    myok( defined Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->iv, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->iv' );
    myis( Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->pData, undef, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->pData' );
    myok( defined Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->iv, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->iv' );
    myis( Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->pData, undef, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->pData' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPassword, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPassword' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPublicData, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPublicData' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pRandomA, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pRandomA' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPrimeP, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pPrimeP' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pBaseG, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pBaseG' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pSubprimeQ, undef, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->pSubprimeQ' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldWrappedX, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldWrappedX' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldPassword, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldPassword' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldPublicData, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldPublicData' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldRandomA, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pOldRandomA' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewPassword, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewPassword' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewPublicData, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewPublicData' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewRandomA, undef, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->pNewRandomA' );
    myok( defined Crypt::PKCS11::CK_PBE_PARAMS->new->pInitVector, 'Crypt::PKCS11::CK_PBE_PARAMS->new->pInitVector' );
    myok( defined Crypt::PKCS11::CK_PBE_PARAMS->new->pPassword, 'Crypt::PKCS11::CK_PBE_PARAMS->new->pPassword' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->pSalt, undef, 'Crypt::PKCS11::CK_PBE_PARAMS->new->pSalt' );
    myok( defined Crypt::PKCS11::CK_PBE_PARAMS->new->ulIteration, 'Crypt::PKCS11::CK_PBE_PARAMS->new->ulIteration' );
    myok( defined Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->bBC, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->bBC' );
    myis( Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->pX, undef, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->pX' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->pClientRandom, undef, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->pClientRandom' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->pServerRandom, undef, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->pServerRandom' );
    myok( defined Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new->RandomInfo, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new->RandomInfo' );
    myok( defined Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new->pVersion, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new->pVersion' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hClientMacSecret, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hClientMacSecret' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hServerMacSecret, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hServerMacSecret' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hClientKey, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hClientKey' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hServerKey, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->hServerKey' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->pIVClient, undef, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->pIVClient' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->pIVServer, undef, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->pIVServer' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulMacSizeInBits, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulMacSizeInBits' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulKeySizeInBits, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulKeySizeInBits' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulIVSizeInBits, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->ulIVSizeInBits' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->bIsExport, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->bIsExport' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->RandomInfo, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->RandomInfo' );
    myok( defined Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->pReturnedKeyMaterial, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->pReturnedKeyMaterial' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pSeed, undef, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pSeed' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pLabel, undef, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pLabel' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pOutput, undef, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->pOutput' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->pClientRandom, undef, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->pClientRandom' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->pServerRandom, undef, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->pServerRandom' );
    myok( defined Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->DigestMechanism, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->DigestMechanism' );
    myok( defined Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->RandomInfo, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->RandomInfo' );
    myok( defined Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->pVersion, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->pVersion' );
    myok( defined Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->DigestMechanism, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->DigestMechanism' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pSeed, undef, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pSeed' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pLabel, undef, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pLabel' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pOutput, undef, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->pOutput' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->hMacSecret, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->hMacSecret' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->hKey, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->hKey' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->pIV, undef, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->pIV' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->DigestMechanism, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->DigestMechanism' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulMacSizeInBits, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulMacSizeInBits' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulKeySizeInBits, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulKeySizeInBits' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulIVSizeInBits, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulIVSizeInBits' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulSequenceNumber, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->ulSequenceNumber' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->bIsExport, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->bIsExport' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->RandomInfo, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->RandomInfo' );
    myok( defined Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->pReturnedKeyMaterial, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->pReturnedKeyMaterial' );
    myok( defined Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->certificateHandle, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->certificateHandle' );
    myok( defined Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pSigningMechanism, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pSigningMechanism' );
    myok( defined Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pDigestMechanism, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pDigestMechanism' );
    myok( defined Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pContentType, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pContentType' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pRequestedAttributes, undef, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pRequestedAttributes' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pRequiredAttributes, undef, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->pRequiredAttributes' );
    myis( Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->pData, undef, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->pData' );
    myok( defined Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->saltSource, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->saltSource' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pSaltSourceData, undef, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pSaltSourceData' );
    myok( defined Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->iterations, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->iterations' );
    myok( defined Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->prf, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->prf' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pPrfData, undef, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pPrfData' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pPassword, undef, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->pPassword' );
    myok( defined Crypt::PKCS11::CK_OTP_PARAM->new->type, 'Crypt::PKCS11::CK_OTP_PARAM->new->type' );
    myis( Crypt::PKCS11::CK_OTP_PARAM->new->pValue, undef, 'Crypt::PKCS11::CK_OTP_PARAM->new->pValue' );
    myok( defined Crypt::PKCS11::CK_OTP_PARAMS->new->pParams, 'Crypt::PKCS11::CK_OTP_PARAMS->new->pParams' );
    myok( defined Crypt::PKCS11::CK_OTP_PARAMS->new->ulCount, 'Crypt::PKCS11::CK_OTP_PARAMS->new->ulCount' );
    myok( defined Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->pParams, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->pParams' );
    myok( defined Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->ulCount, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->ulCount' );
    myok( defined Crypt::PKCS11::CK_KIP_PARAMS->new->pMechanism, 'Crypt::PKCS11::CK_KIP_PARAMS->new->pMechanism' );
    myok( defined Crypt::PKCS11::CK_KIP_PARAMS->new->hKey, 'Crypt::PKCS11::CK_KIP_PARAMS->new->hKey' );
    myis( Crypt::PKCS11::CK_KIP_PARAMS->new->pSeed, undef, 'Crypt::PKCS11::CK_KIP_PARAMS->new->pSeed' );
    myok( defined Crypt::PKCS11::CK_AES_CTR_PARAMS->new->ulCounterBits, 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new->ulCounterBits' );
    myok( defined Crypt::PKCS11::CK_AES_CTR_PARAMS->new->cb, 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new->cb' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->pIv, undef, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->pIv' );
    myok( defined Crypt::PKCS11::CK_AES_GCM_PARAMS->new->ulIvBits, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->ulIvBits' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->pAAD, undef, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->pAAD' );
    myok( defined Crypt::PKCS11::CK_AES_GCM_PARAMS->new->ulTagBits, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->ulTagBits' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->pNonce, undef, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->pNonce' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->pAAD, undef, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->pAAD' );
    myok( defined Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->ulCounterBits, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->ulCounterBits' );
    myok( defined Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->cb, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->cb' );
    myok( defined Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->iv, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->iv' );
    myis( Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->pData, undef, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->pData' );
    myok( defined Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->iv, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->iv' );
    myis( Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->pData, undef, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->pData' );

    myisa_ok( $obj = Crypt::PKCS11::CK_VERSION->new, 'Crypt::PKCS11::CK_VERSIONPtr', 'Crypt::PKCS11::CK_VERSION->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_MECHANISM->new, 'Crypt::PKCS11::CK_MECHANISMPtr', 'Crypt::PKCS11::CK_MECHANISM->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC2_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC2_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_PARAMS->new, 'Crypt::PKCS11::CK_RC5_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC5_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_PBE_PARAMS->new, 'Crypt::PKCS11::CK_PBE_PARAMSPtr', 'Crypt::PKCS11::CK_PBE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_TLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_TLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_CMS_SIG_PARAMS->new, 'Crypt::PKCS11::CK_CMS_SIG_PARAMSPtr', 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATAPtr', 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMSPtr', 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_PARAM->new, 'Crypt::PKCS11::CK_OTP_PARAMPtr', 'Crypt::PKCS11::CK_OTP_PARAM->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_PARAMS->new, 'Crypt::PKCS11::CK_OTP_PARAMSPtr', 'Crypt::PKCS11::CK_OTP_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFOPtr', 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KIP_PARAMS->new, 'Crypt::PKCS11::CK_KIP_PARAMSPtr', 'Crypt::PKCS11::CK_KIP_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CTR_PARAMS->new, 'Crypt::PKCS11::CK_AES_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_GCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_GCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_CCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myis( $obj->fromBytes(undef), CKR_ARGUMENTS_BAD, '$obj->fromBytes(undef)' );
    myis( $obj->fromBytes(''), CKR_ARGUMENTS_BAD, '$obj->fromBytes("")' );
    myis( $obj->fromBytes($bytes), CKR_OK, '$obj->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_VERSION->new, 'Crypt::PKCS11::CK_VERSIONPtr', 'Crypt::PKCS11::CK_VERSION->new' );
    myis( $obj->set_major(1), CKR_OK, '$obj->set_major(1)' );
    myis( $obj->set_major(1), CKR_OK, '$obj->set_major(1)' );
    myis( $obj->set_minor(1), CKR_OK, '$obj->set_minor(1)' );
    myis( $obj->set_minor(1), CKR_OK, '$obj->set_minor(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_VERSION->new, 'Crypt::PKCS11::CK_VERSIONPtr', 'Crypt::PKCS11::CK_VERSION->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_MECHANISM->new, 'Crypt::PKCS11::CK_MECHANISMPtr', 'Crypt::PKCS11::CK_MECHANISM->new' );
    myis( $obj->set_mechanism(1), CKR_OK, '$obj->set_mechanism(1)' );
    myis( $obj->set_mechanism(1), CKR_OK, '$obj->set_mechanism(1)' );
    myis( $obj->set_pParameter('1'), CKR_OK, '$obj->set_pParameter("1")' );
    myis( $obj->set_pParameter('1'), CKR_OK, '$obj->set_pParameter("1")' );
    myis( $obj->set_pParameter(undef), CKR_OK, '$obj->set_pParameter(undef)' );
    myis( $obj->set_pParameter('1'), CKR_OK, '$obj->set_pParameter("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_MECHANISM->new, 'Crypt::PKCS11::CK_MECHANISMPtr', 'Crypt::PKCS11::CK_MECHANISM->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new' );
    myis( $obj->set_hashAlg(1), CKR_OK, '$obj->set_hashAlg(1)' );
    myis( $obj->set_hashAlg(1), CKR_OK, '$obj->set_hashAlg(1)' );
    myis( $obj->set_mgf(1), CKR_OK, '$obj->set_mgf(1)' );
    myis( $obj->set_mgf(1), CKR_OK, '$obj->set_mgf(1)' );
    myis( $obj->set_source(1), CKR_OK, '$obj->set_source(1)' );
    myis( $obj->set_source(1), CKR_OK, '$obj->set_source(1)' );
    myis( $obj->set_pSourceData('1'), CKR_OK, '$obj->set_pSourceData("1")' );
    myis( $obj->set_pSourceData('1'), CKR_OK, '$obj->set_pSourceData("1")' );
    myis( $obj->set_pSourceData(undef), CKR_OK, '$obj->set_pSourceData(undef)' );
    myis( $obj->set_pSourceData('1'), CKR_OK, '$obj->set_pSourceData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new' );
    myis( $obj->set_hashAlg(1), CKR_OK, '$obj->set_hashAlg(1)' );
    myis( $obj->set_hashAlg(1), CKR_OK, '$obj->set_hashAlg(1)' );
    myis( $obj->set_mgf(1), CKR_OK, '$obj->set_mgf(1)' );
    myis( $obj->set_mgf(1), CKR_OK, '$obj->set_mgf(1)' );
    myis( $obj->set_sLen(1), CKR_OK, '$obj->set_sLen(1)' );
    myis( $obj->set_sLen(1), CKR_OK, '$obj->set_sLen(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMSPtr', 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData(undef), CKR_OK, '$obj->set_pSharedData(undef)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData(undef), CKR_OK, '$obj->set_pSharedData(undef)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2(undef), CKR_OK, '$obj->set_pPublicData2(undef)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pSharedData(undef), CKR_OK, '$obj->set_pSharedData(undef)' );
    myis( $obj->set_pSharedData('1'), CKR_OK, '$obj->set_pSharedData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2(undef), CKR_OK, '$obj->set_pPublicData2(undef)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_publicKey(1), CKR_OK, '$obj->set_publicKey(1)' );
    myis( $obj->set_publicKey(1), CKR_OK, '$obj->set_publicKey(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo(undef), CKR_OK, '$obj->set_pOtherInfo(undef)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo(undef), CKR_OK, '$obj->set_pOtherInfo(undef)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2(undef), CKR_OK, '$obj->set_pPublicData2(undef)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_kdf(1), CKR_OK, '$obj->set_kdf(1)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pOtherInfo(undef), CKR_OK, '$obj->set_pOtherInfo(undef)' );
    myis( $obj->set_pOtherInfo('1'), CKR_OK, '$obj->set_pOtherInfo("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_hPrivateData(1), CKR_OK, '$obj->set_hPrivateData(1)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_pPublicData2(undef), CKR_OK, '$obj->set_pPublicData2(undef)' );
    myis( $obj->set_pPublicData2('1'), CKR_OK, '$obj->set_pPublicData2("1")' );
    myis( $obj->set_publicKey(1), CKR_OK, '$obj->set_publicKey(1)' );
    myis( $obj->set_publicKey(1), CKR_OK, '$obj->set_publicKey(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new' );
    myis( $obj->set_isSender(1), CKR_OK, '$obj->set_isSender(1)' );
    myis( $obj->set_isSender(1), CKR_OK, '$obj->set_isSender(1)' );
    myis( $obj->set_isSender(0), CKR_OK, '$obj->set_isSender(0)' );
    myis( $obj->set_isSender(0), CKR_OK, '$obj->set_isSender(0)' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pRandomA(undef), CKR_OK, '$obj->set_pRandomA(undef)' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pRandomB('1'), CKR_OK, '$obj->set_pRandomB("1")' );
    myis( $obj->set_pRandomB('1'), CKR_OK, '$obj->set_pRandomB("1")' );
    myis( $obj->set_pRandomB(undef), CKR_OK, '$obj->set_pRandomB(undef)' );
    myis( $obj->set_pRandomB('1'), CKR_OK, '$obj->set_pRandomB("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC2_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC2_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new' );
    myis( $obj->set_ulEffectiveBits(1), CKR_OK, '$obj->set_ulEffectiveBits(1)' );
    myis( $obj->set_ulEffectiveBits(1), CKR_OK, '$obj->set_ulEffectiveBits(1)' );
    myis( $obj->set_iv('123456789'), CKR_ARGUMENTS_BAD, '$obj->set_iv("123456789")' );
    myis( $obj->set_iv(-1), CKR_ARGUMENTS_BAD, '$obj->set_iv(-1)' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myis( $obj->set_iv(undef), CKR_OK, '$obj->set_iv(undef)' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RC2_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC2_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new' );
    myis( $obj->set_ulEffectiveBits(1), CKR_OK, '$obj->set_ulEffectiveBits(1)' );
    myis( $obj->set_ulEffectiveBits(1), CKR_OK, '$obj->set_ulEffectiveBits(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_PARAMS->new, 'Crypt::PKCS11::CK_RC5_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_PARAMS->new' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RC5_PARAMS->new, 'Crypt::PKCS11::CK_RC5_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC5_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myis( $obj->set_pIv(undef), CKR_OK, '$obj->set_pIv(undef)' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RC5_CBC_PARAMS->new, 'Crypt::PKCS11::CK_RC5_CBC_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulWordsize(1), CKR_OK, '$obj->set_ulWordsize(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myis( $obj->set_ulRounds(1), CKR_OK, '$obj->set_ulRounds(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMSPtr', 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj->set_iv('123456789'), CKR_ARGUMENTS_BAD, '$obj->set_iv("123456789")' );
    myis( $obj->set_iv(-1), CKR_ARGUMENTS_BAD, '$obj->set_iv(-1)' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myis( $obj->set_iv(undef), CKR_OK, '$obj->set_iv(undef)' );
    myis( $obj->set_iv('12345678'), CKR_OK, '$obj->set_iv("12345678")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData(undef), CKR_OK, '$obj->set_pData(undef)' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj->set_iv('12345678123456789'), CKR_ARGUMENTS_BAD, '$obj->set_iv("12345678123456789")' );
    myis( $obj->set_iv(-1), CKR_ARGUMENTS_BAD, '$obj->set_iv(-1)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv(undef), CKR_OK, '$obj->set_iv(undef)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData(undef), CKR_OK, '$obj->set_pData(undef)' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pPassword(undef), CKR_OK, '$obj->set_pPassword(undef)' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pPublicData(undef), CKR_OK, '$obj->set_pPublicData(undef)' );
    myis( $obj->set_pPublicData('1'), CKR_OK, '$obj->set_pPublicData("1")' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pRandomA(undef), CKR_OK, '$obj->set_pRandomA(undef)' );
    myis( $obj->set_pRandomA('1'), CKR_OK, '$obj->set_pRandomA("1")' );
    myis( $obj->set_pPrimeP('1'), CKR_OK, '$obj->set_pPrimeP("1")' );
    myis( $obj->set_pPrimeP('1'), CKR_OK, '$obj->set_pPrimeP("1")' );
    myis( $obj->set_pPrimeP(undef), CKR_OK, '$obj->set_pPrimeP(undef)' );
    myis( $obj->set_pPrimeP('1'), CKR_OK, '$obj->set_pPrimeP("1")' );
    myis( $obj->set_pBaseG('1'), CKR_OK, '$obj->set_pBaseG("1")' );
    myis( $obj->set_pBaseG('1'), CKR_OK, '$obj->set_pBaseG("1")' );
    myis( $obj->set_pBaseG(undef), CKR_OK, '$obj->set_pBaseG(undef)' );
    myis( $obj->set_pBaseG('1'), CKR_OK, '$obj->set_pBaseG("1")' );
    myis( $obj->set_pSubprimeQ('1'), CKR_OK, '$obj->set_pSubprimeQ("1")' );
    myis( $obj->set_pSubprimeQ('1'), CKR_OK, '$obj->set_pSubprimeQ("1")' );
    myis( $obj->set_pSubprimeQ(undef), CKR_OK, '$obj->set_pSubprimeQ(undef)' );
    myis( $obj->set_pSubprimeQ('1'), CKR_OK, '$obj->set_pSubprimeQ("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new' );
    myis( $obj->set_pOldWrappedX('1'), CKR_OK, '$obj->set_pOldWrappedX("1")' );
    myis( $obj->set_pOldWrappedX('1'), CKR_OK, '$obj->set_pOldWrappedX("1")' );
    myis( $obj->set_pOldWrappedX(undef), CKR_OK, '$obj->set_pOldWrappedX(undef)' );
    myis( $obj->set_pOldWrappedX('1'), CKR_OK, '$obj->set_pOldWrappedX("1")' );
    myis( $obj->set_pOldPassword('1'), CKR_OK, '$obj->set_pOldPassword("1")' );
    myis( $obj->set_pOldPassword('1'), CKR_OK, '$obj->set_pOldPassword("1")' );
    myis( $obj->set_pOldPassword(undef), CKR_OK, '$obj->set_pOldPassword(undef)' );
    myis( $obj->set_pOldPassword('1'), CKR_OK, '$obj->set_pOldPassword("1")' );
    myis( $obj->set_pOldPublicData('1'), CKR_OK, '$obj->set_pOldPublicData("1")' );
    myis( $obj->set_pOldPublicData('1'), CKR_OK, '$obj->set_pOldPublicData("1")' );
    myis( $obj->set_pOldPublicData(undef), CKR_OK, '$obj->set_pOldPublicData(undef)' );
    myis( $obj->set_pOldPublicData('1'), CKR_OK, '$obj->set_pOldPublicData("1")' );
    myis( $obj->set_pOldRandomA('1'), CKR_OK, '$obj->set_pOldRandomA("1")' );
    myis( $obj->set_pOldRandomA('1'), CKR_OK, '$obj->set_pOldRandomA("1")' );
    myis( $obj->set_pOldRandomA(undef), CKR_OK, '$obj->set_pOldRandomA(undef)' );
    myis( $obj->set_pOldRandomA('1'), CKR_OK, '$obj->set_pOldRandomA("1")' );
    myis( $obj->set_pNewPassword('1'), CKR_OK, '$obj->set_pNewPassword("1")' );
    myis( $obj->set_pNewPassword('1'), CKR_OK, '$obj->set_pNewPassword("1")' );
    myis( $obj->set_pNewPassword(undef), CKR_OK, '$obj->set_pNewPassword(undef)' );
    myis( $obj->set_pNewPassword('1'), CKR_OK, '$obj->set_pNewPassword("1")' );
    myis( $obj->set_pNewPublicData('1'), CKR_OK, '$obj->set_pNewPublicData("1")' );
    myis( $obj->set_pNewPublicData('1'), CKR_OK, '$obj->set_pNewPublicData("1")' );
    myis( $obj->set_pNewPublicData(undef), CKR_OK, '$obj->set_pNewPublicData(undef)' );
    myis( $obj->set_pNewPublicData('1'), CKR_OK, '$obj->set_pNewPublicData("1")' );
    myis( $obj->set_pNewRandomA('1'), CKR_OK, '$obj->set_pNewRandomA("1")' );
    myis( $obj->set_pNewRandomA('1'), CKR_OK, '$obj->set_pNewRandomA("1")' );
    myis( $obj->set_pNewRandomA(undef), CKR_OK, '$obj->set_pNewRandomA(undef)' );
    myis( $obj->set_pNewRandomA('1'), CKR_OK, '$obj->set_pNewRandomA("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMSPtr', 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_PBE_PARAMS->new, 'Crypt::PKCS11::CK_PBE_PARAMSPtr', 'Crypt::PKCS11::CK_PBE_PARAMS->new' );
    myis( $obj->set_pInitVector('123456789'), CKR_ARGUMENTS_BAD, '$obj->set_pInitVector("123456789")' );
    myis( $obj->set_pInitVector(-1), CKR_ARGUMENTS_BAD, '$obj->set_pInitVector(-1)' );
    myis( $obj->set_pInitVector('12345678'), CKR_OK, '$obj->set_pInitVector("12345678")' );
    myis( $obj->set_pInitVector('12345678'), CKR_OK, '$obj->set_pInitVector("12345678")' );
    myis( $obj->set_pInitVector(undef), CKR_OK, '$obj->set_pInitVector(undef)' );
    myis( $obj->set_pInitVector('12345678'), CKR_OK, '$obj->set_pInitVector("12345678")' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pPassword(undef), CKR_OK, '$obj->set_pPassword(undef)' );
    myis( $obj->set_pPassword('1'), CKR_OK, '$obj->set_pPassword("1")' );
    myis( $obj->set_pSalt('1'), CKR_OK, '$obj->set_pSalt("1")' );
    myis( $obj->set_pSalt('1'), CKR_OK, '$obj->set_pSalt("1")' );
    myis( $obj->set_pSalt(undef), CKR_OK, '$obj->set_pSalt(undef)' );
    myis( $obj->set_pSalt('1'), CKR_OK, '$obj->set_pSalt("1")' );
    myis( $obj->set_ulIteration(1), CKR_OK, '$obj->set_ulIteration(1)' );
    myis( $obj->set_ulIteration(1), CKR_OK, '$obj->set_ulIteration(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_PBE_PARAMS->new, 'Crypt::PKCS11::CK_PBE_PARAMSPtr', 'Crypt::PKCS11::CK_PBE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes("\0" x length($bytes)), CKR_OK, '$obj2->fromBytes("\0" x length($bytes))' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new' );
    myis( $obj->set_bBC(1), CKR_OK, '$obj->set_bBC(1)' );
    myis( $obj->set_bBC(1), CKR_OK, '$obj->set_bBC(1)' );
    myis( $obj->set_pX('1'), CKR_OK, '$obj->set_pX("1")' );
    myis( $obj->set_pX('1'), CKR_OK, '$obj->set_pX("1")' );
    myis( $obj->set_pX(undef), CKR_OK, '$obj->set_pX(undef)' );
    myis( $obj->set_pX('1'), CKR_OK, '$obj->set_pX("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMSPtr', 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pClientRandom(undef), CKR_OK, '$obj->set_pClientRandom(undef)' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    myis( $obj->set_pServerRandom(undef), CKR_OK, '$obj->set_pServerRandom(undef)' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    $randomInfo = $obj;
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new), CKR_OK, '$obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new)' );
    myis( $obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new), CKR_OK, '$obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new)' );
    myis( $obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new), CKR_OK, '$obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new)' );
    myis( $obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new), CKR_OK, '$obj->set_pVersion(Crypt::PKCS11::CK_VERSION->new)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->get_RandomInfo($a = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->get_RandomInfo($a), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myisa_ok( $randomInfo2 = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new' );
    myis( $obj->set_RandomInfo($randomInfo2), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new' );
    myis( $obj->set_hClientMacSecret(1), CKR_OK, '$obj->set_hClientMacSecret(1)' );
    myis( $obj->set_hClientMacSecret(1), CKR_OK, '$obj->set_hClientMacSecret(1)' );
    myis( $obj->set_hServerMacSecret(1), CKR_OK, '$obj->set_hServerMacSecret(1)' );
    myis( $obj->set_hServerMacSecret(1), CKR_OK, '$obj->set_hServerMacSecret(1)' );
    myis( $obj->set_hClientKey(1), CKR_OK, '$obj->set_hClientKey(1)' );
    myis( $obj->set_hClientKey(1), CKR_OK, '$obj->set_hClientKey(1)' );
    myis( $obj->set_hServerKey(1), CKR_OK, '$obj->set_hServerKey(1)' );
    myis( $obj->set_hServerKey(1), CKR_OK, '$obj->set_hServerKey(1)' );
    myis( $obj->set_pIVClient('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVClient("1")' );
    myis( $obj->set_pIVClient('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVClient("1")' );
    myis( $obj->set_pIVClient(undef), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVClient(undef)' );
    myis( $obj->set_pIVClient('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVClient("1")' );
    myis( $obj->set_pIVServer('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVServer("1")' );
    myis( $obj->set_pIVServer('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVServer("1")' );
    myis( $obj->set_pIVServer(undef), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVServer(undef)' );
    myis( $obj->set_pIVServer('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIVServer("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new' );
    myis( $obj->set_ulMacSizeInBits(1), CKR_OK, '$obj->set_ulMacSizeInBits(1)' );
    myis( $obj->set_ulMacSizeInBits(1), CKR_OK, '$obj->set_ulMacSizeInBits(1)' );
    myis( $obj->set_ulKeySizeInBits(1), CKR_OK, '$obj->set_ulKeySizeInBits(1)' );
    myis( $obj->set_ulKeySizeInBits(1), CKR_OK, '$obj->set_ulKeySizeInBits(1)' );
    myis( $obj->set_ulIVSizeInBits(1), CKR_OK, '$obj->set_ulIVSizeInBits(1)' );
    myis( $obj->set_ulIVSizeInBits(1), CKR_OK, '$obj->set_ulIVSizeInBits(1)' );
    myis( $obj->get_pReturnedKeyMaterial($a = Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new), CKR_GENERAL_ERROR, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->set_ulIVSizeInBits(16), CKR_OK, '$obj->set_ulIVSizeInBits(16)' );
    myis( $obj->get_pReturnedKeyMaterial($a = Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new), CKR_OK, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->get_pReturnedKeyMaterial($a), CKR_OK, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->set_bIsExport(1), CKR_OK, '$obj->set_bIsExport(1)' );
    myis( $obj->set_bIsExport(1), CKR_OK, '$obj->set_bIsExport(1)' );
    myis( $obj->set_bIsExport(0), CKR_OK, '$obj->set_bIsExport(0)' );
    myis( $obj->set_bIsExport(0), CKR_OK, '$obj->set_bIsExport(0)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->get_RandomInfo($a = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->get_RandomInfo($a), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myisa_ok( $randomInfo2 = Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new' );
    myis( $obj->set_RandomInfo($randomInfo2), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_TLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_TLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new' );
    myis( $obj->get_pOutput($a = ''), CKR_OK );
    myis( $obj->get_pOutput($a = undef), CKR_FUNCTION_FAILED );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->get_pOutput($a = undef), CKR_OK );
    myis( $obj->get_pOutput($a = ''), CKR_OK );

    myisa_ok( $obj = Crypt::PKCS11::CK_TLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_TLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed(undef), CKR_OK, '$obj->set_pSeed(undef)' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pLabel(undef), CKR_OK, '$obj->set_pLabel(undef)' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->set_pOutput(undef), CKR_OK, '$obj->set_pOutput(undef)' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );

    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_TLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_TLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pClientRandom(undef), CKR_OK, '$obj->set_pClientRandom(undef)' );
    myis( $obj->set_pClientRandom('1'), CKR_OK, '$obj->set_pClientRandom("1")' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    myis( $obj->set_pServerRandom(undef), CKR_OK, '$obj->set_pServerRandom(undef)' );
    myis( $obj->set_pServerRandom('1'), CKR_OK, '$obj->set_pServerRandom("1")' );
    $randomInfo = $obj;
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_pVersion('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pVersion("1")' );
    myis( $obj->set_pVersion('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pVersion("1")' );
    myis( $obj->set_pVersion(undef), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pVersion(undef)' );
    myis( $obj->set_pVersion('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pVersion("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->get_RandomInfo($a = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->get_RandomInfo($a), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myisa_ok( $randomInfo2 = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new' );
    myis( $obj->set_RandomInfo($randomInfo2), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new' );
    myis( $obj->get_pOutput($a = ''), CKR_OK );
    myis( $obj->get_pOutput($a = undef), CKR_FUNCTION_FAILED );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->get_pOutput($a = undef), CKR_OK );
    myis( $obj->get_pOutput($a = ''), CKR_OK );

    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed(undef), CKR_OK, '$obj->set_pSeed(undef)' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pLabel(undef), CKR_OK, '$obj->set_pLabel(undef)' );
    myis( $obj->set_pLabel('1'), CKR_OK, '$obj->set_pLabel("1")' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myis( $obj->set_pOutput(undef), CKR_OK, '$obj->set_pOutput(undef)' );
    myis( $obj->set_pOutput(1), CKR_OK, '$obj->set_pOutput(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new' );
    myis( $obj->set_hMacSecret(1), CKR_OK, '$obj->set_hMacSecret(1)' );
    myis( $obj->set_hMacSecret(1), CKR_OK, '$obj->set_hMacSecret(1)' );
    myis( $obj->set_hKey(1), CKR_OK, '$obj->set_hKey(1)' );
    myis( $obj->set_hKey(1), CKR_OK, '$obj->set_hKey(1)' );
    myis( $obj->set_pIV('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIV("1")' );
    myis( $obj->set_pIV('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIV("1")' );
    myis( $obj->set_pIV(undef), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIV(undef)' );
    myis( $obj->set_pIV('1'), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_pIV("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUTPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_DigestMechanism(1), CKR_OK, '$obj->set_DigestMechanism(1)' );
    myis( $obj->set_ulMacSizeInBits(1), CKR_OK, '$obj->set_ulMacSizeInBits(1)' );
    myis( $obj->set_ulMacSizeInBits(1), CKR_OK, '$obj->set_ulMacSizeInBits(1)' );
    myis( $obj->set_ulKeySizeInBits(1), CKR_OK, '$obj->set_ulKeySizeInBits(1)' );
    myis( $obj->set_ulKeySizeInBits(1), CKR_OK, '$obj->set_ulKeySizeInBits(1)' );
    myis( $obj->set_ulIVSizeInBits(1), CKR_OK, '$obj->set_ulIVSizeInBits(1)' );
    myis( $obj->set_ulIVSizeInBits(1), CKR_OK, '$obj->set_ulIVSizeInBits(1)' );
    myis( $obj->get_pReturnedKeyMaterial($a = Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new), CKR_GENERAL_ERROR, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->set_ulIVSizeInBits(16), CKR_OK, '$obj->set_ulIVSizeInBits(16)' );
    myis( $obj->get_pReturnedKeyMaterial($a = Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new), CKR_OK, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->get_pReturnedKeyMaterial($a), CKR_OK, '$obj->get_pReturnedKeyMaterial' );
    myis( $obj->set_ulSequenceNumber(1), CKR_OK, '$obj->set_ulSequenceNumber(1)' );
    myis( $obj->set_ulSequenceNumber(1), CKR_OK, '$obj->set_ulSequenceNumber(1)' );
    myis( $obj->set_bIsExport(1), CKR_OK, '$obj->set_bIsExport(1)' );
    myis( $obj->set_bIsExport(1), CKR_OK, '$obj->set_bIsExport(1)' );
    myis( $obj->set_bIsExport(0), CKR_OK, '$obj->set_bIsExport(0)' );
    myis( $obj->set_bIsExport(0), CKR_OK, '$obj->set_bIsExport(0)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_FUNCTION_NOT_SUPPORTED, '$obj2->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMSPtr', 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myis( $obj->get_RandomInfo($a = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->get_RandomInfo($a), CKR_OK, '$obj->get_RandomInfo' );
    myis( $obj->set_RandomInfo($randomInfo), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );
    myisa_ok( $randomInfo2 = Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr', 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new' );
    myis( $obj->set_RandomInfo($randomInfo2), CKR_OK, '$obj->set_RandomInfo($randomInfo)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_CMS_SIG_PARAMS->new, 'Crypt::PKCS11::CK_CMS_SIG_PARAMSPtr', 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new' );
    myis( $obj->set_certificateHandle(1), CKR_OK, '$obj->set_certificateHandle(1)' );
    myis( $obj->set_certificateHandle(1), CKR_OK, '$obj->set_certificateHandle(1)' );
    $mech = Crypt::PKCS11::CK_MECHANISM->new;
    myis( $mech->set_pParameter(' '), CKR_OK );
    myis( $obj->set_pSigningMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pSigningMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pSigningMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pSigningMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pSigningMechanism($mech), CKR_OK, '$obj->set_pSigningMechanism($mech)' );
    myis( $obj->set_pSigningMechanism($mech), CKR_OK, '$obj->set_pSigningMechanism($mech)' );
    myis( $obj->get_pSigningMechanism($a = Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->get_pSigningMechanism' );
    myis( $obj->get_pSigningMechanism($a), CKR_OK, '$obj->get_pSigningMechanism' );
    myis( $obj->set_pDigestMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pDigestMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pDigestMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pDigestMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pDigestMechanism($mech), CKR_OK, '$obj->set_pDigestMechanism($mech)' );
    myis( $obj->set_pDigestMechanism($mech), CKR_OK, '$obj->set_pDigestMechanism($mech)' );
    myis( $obj->get_pDigestMechanism($a = Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->get_pDigestMechanism' );
    myis( $obj->get_pDigestMechanism($a), CKR_OK, '$obj->get_pDigestMechanism' );
    myis( $obj->set_pContentType('1'), CKR_OK, '$obj->set_pContentType("1")' );
    myis( $obj->set_pContentType('1'), CKR_OK, '$obj->set_pContentType("1")' );
    myis( $obj->set_pContentType(undef), CKR_OK, '$obj->set_pContentType(undef)' );
    myis( $obj->set_pContentType('1'), CKR_OK, '$obj->set_pContentType("1")' );
    myis( $obj->set_pRequestedAttributes('1'), CKR_OK, '$obj->set_pRequestedAttributes("1")' );
    myis( $obj->set_pRequestedAttributes('1'), CKR_OK, '$obj->set_pRequestedAttributes("1")' );
    myis( $obj->set_pRequestedAttributes(undef), CKR_OK, '$obj->set_pRequestedAttributes(undef)' );
    myis( $obj->set_pRequestedAttributes('1'), CKR_OK, '$obj->set_pRequestedAttributes("1")' );
    myis( $obj->set_pRequiredAttributes('1'), CKR_OK, '$obj->set_pRequiredAttributes("1")' );
    myis( $obj->set_pRequiredAttributes('1'), CKR_OK, '$obj->set_pRequiredAttributes("1")' );
    myis( $obj->set_pRequiredAttributes(undef), CKR_OK, '$obj->set_pRequiredAttributes(undef)' );
    myis( $obj->set_pRequiredAttributes('1'), CKR_OK, '$obj->set_pRequiredAttributes("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_CMS_SIG_PARAMS->new, 'Crypt::PKCS11::CK_CMS_SIG_PARAMSPtr', 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATAPtr', 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData(undef), CKR_OK, '$obj->set_pData(undef)' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATAPtr', 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );

    myisa_ok( $obj = Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMSPtr', 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new' );
    myis( $obj->get_pPassword($a = ''), CKR_OK );
    myis( $obj->get_pPassword($a = undef), CKR_FUNCTION_FAILED );
    myis( $obj->set_pPassword(1), CKR_OK, '$obj->set_pPassword(1)' );
    myis( $obj->get_pPassword($a = undef), CKR_OK );
    myis( $obj->get_pPassword($a = ''), CKR_OK );

    myisa_ok( $obj = Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMSPtr', 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new' );
    myis( $obj->set_saltSource(1), CKR_OK, '$obj->set_saltSource(1)' );
    myis( $obj->set_saltSource(1), CKR_OK, '$obj->set_saltSource(1)' );
    myis( $obj->set_pSaltSourceData('1'), CKR_OK, '$obj->set_pSaltSourceData("1")' );
    myis( $obj->set_pSaltSourceData('1'), CKR_OK, '$obj->set_pSaltSourceData("1")' );
    myis( $obj->set_pSaltSourceData(undef), CKR_OK, '$obj->set_pSaltSourceData(undef)' );
    myis( $obj->set_pSaltSourceData('1'), CKR_OK, '$obj->set_pSaltSourceData("1")' );
    myis( $obj->set_iterations(1), CKR_OK, '$obj->set_iterations(1)' );
    myis( $obj->set_iterations(1), CKR_OK, '$obj->set_iterations(1)' );
    myis( $obj->set_prf(1), CKR_OK, '$obj->set_prf(1)' );
    myis( $obj->set_prf(1), CKR_OK, '$obj->set_prf(1)' );
    myis( $obj->set_pPrfData('1'), CKR_OK, '$obj->set_pPrfData("1")' );
    myis( $obj->set_pPrfData('1'), CKR_OK, '$obj->set_pPrfData("1")' );
    myis( $obj->set_pPrfData(undef), CKR_OK, '$obj->set_pPrfData(undef)' );
    myis( $obj->set_pPrfData('1'), CKR_OK, '$obj->set_pPrfData("1")' );
    myis( $obj->set_pPassword(1), CKR_OK, '$obj->set_pPassword(1)' );
    myis( $obj->set_pPassword(1), CKR_OK, '$obj->set_pPassword(1)' );
    myis( $obj->set_pPassword(undef), CKR_OK, '$obj->set_pPassword(undef)' );
    myis( $obj->set_pPassword(1), CKR_OK, '$obj->set_pPassword(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMSPtr', 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_PARAM->new, 'Crypt::PKCS11::CK_OTP_PARAMPtr', 'Crypt::PKCS11::CK_OTP_PARAM->new' );
    myis( $obj->set_type(1), CKR_OK, '$obj->set_type(1)' );
    myis( $obj->set_type(1), CKR_OK, '$obj->set_type(1)' );
    myis( $obj->set_pValue('1'), CKR_OK, '$obj->set_pValue("1")' );
    myis( $obj->set_pValue('1'), CKR_OK, '$obj->set_pValue("1")' );
    myis( $obj->set_pValue(undef), CKR_OK, '$obj->set_pValue(undef)' );
    myis( $obj->set_pValue('1'), CKR_OK, '$obj->set_pValue("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_OTP_PARAM->new, 'Crypt::PKCS11::CK_OTP_PARAMPtr', 'Crypt::PKCS11::CK_OTP_PARAM->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    my @a = ($obj, $obj2);
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_PARAMS->new, 'Crypt::PKCS11::CK_OTP_PARAMSPtr', 'Crypt::PKCS11::CK_OTP_PARAMS->new' );
    myis( $obj->set_pParams(\@a), CKR_OK, '$obj->set_pParams(\@a)' );
    myis( $obj->set_pParams(\@a), CKR_OK, '$obj->set_pParams(\@a)' );
    myis( $obj->set_pParams([Crypt::PKCS11::CK_OTP_PARAMS->new]), CKR_ARGUMENTS_BAD, '$obj->set_pParams' );
    myis( $obj->get_pParams($b = []), CKR_OK, '$obj->get_pParams($b = [])' );
    $b = undef;
    myis( $obj->set_ulCount(1), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_ulCount(1)' );
    myis( $obj->set_ulCount(1), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_ulCount(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_OTP_PARAMS->new, 'Crypt::PKCS11::CK_OTP_PARAMSPtr', 'Crypt::PKCS11::CK_OTP_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFOPtr', 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new' );
    myis( $obj->set_pParams(\@a), CKR_OK, '$obj->set_pParams(\@a)' );
    myis( $obj->set_pParams(\@a), CKR_OK, '$obj->set_pParams(\@a)' );
    myis( $obj->set_pParams([Crypt::PKCS11::CK_OTP_PARAMS->new]), CKR_ARGUMENTS_BAD, '$obj->set_pParams' );
    myis( $obj->get_pParams($b = []), CKR_OK, '$obj->get_pParams($b = [])' );
    $b = undef;
    myis( $obj->set_ulCount(1), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_ulCount(1)' );
    myis( $obj->set_ulCount(1), CKR_FUNCTION_NOT_SUPPORTED, '$obj->set_ulCount(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFOPtr', 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_KIP_PARAMS->new, 'Crypt::PKCS11::CK_KIP_PARAMSPtr', 'Crypt::PKCS11::CK_KIP_PARAMS->new' );
    $mech = Crypt::PKCS11::CK_MECHANISM->new;
    myis( $mech->set_pParameter(' '), CKR_OK );
    myis( $obj->set_pMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pMechanism(Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pMechanism(Crypt::PKCS11::CK_MECHANISM->new)' );
    myis( $obj->set_pMechanism($mech), CKR_OK, '$obj->set_pMechanism($mech)' );
    myis( $obj->set_pMechanism($mech), CKR_OK, '$obj->set_pMechanism($mech)' );
    myis( $obj->get_pMechanism($a = Crypt::PKCS11::CK_MECHANISM->new), CKR_OK, '$obj->set_pMechanism' );
    myis( $obj->get_pMechanism($a), CKR_OK, '$obj->set_pMechanism' );
    myis( $obj->set_hKey(1), CKR_OK, '$obj->set_hKey(1)' );
    myis( $obj->set_hKey(1), CKR_OK, '$obj->set_hKey(1)' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myis( $obj->set_pSeed(undef), CKR_OK, '$obj->set_pSeed(undef)' );
    myis( $obj->set_pSeed('1'), CKR_OK, '$obj->set_pSeed("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_KIP_PARAMS->new, 'Crypt::PKCS11::CK_KIP_PARAMSPtr', 'Crypt::PKCS11::CK_KIP_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CTR_PARAMS->new, 'Crypt::PKCS11::CK_AES_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new' );
    myis( $obj->set_ulCounterBits(1), CKR_OK, '$obj->set_ulCounterBits(1)' );
    myis( $obj->set_ulCounterBits(1), CKR_OK, '$obj->set_ulCounterBits(1)' );
    myis( $obj->set_cb('12345678123456789'), CKR_ARGUMENTS_BAD, '$obj->set_cb("12345678123456789")' );
    myis( $obj->set_cb(-1), CKR_ARGUMENTS_BAD, '$obj->set_cb(-1)' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myis( $obj->set_cb(undef), CKR_OK, '$obj->set_cb(undef)' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_AES_CTR_PARAMS->new, 'Crypt::PKCS11::CK_AES_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_GCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_GCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myis( $obj->set_pIv(undef), CKR_OK, '$obj->set_pIv(undef)' );
    myis( $obj->set_pIv('1'), CKR_OK, '$obj->set_pIv("1")' );
    myis( $obj->set_ulIvBits(1), CKR_OK, '$obj->set_ulIvBits(1)' );
    myis( $obj->set_ulIvBits(1), CKR_OK, '$obj->set_ulIvBits(1)' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myis( $obj->set_pAAD(undef), CKR_OK, '$obj->set_pAAD(undef)' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myis( $obj->set_ulTagBits(1), CKR_OK, '$obj->set_ulTagBits(1)' );
    myis( $obj->set_ulTagBits(1), CKR_OK, '$obj->set_ulTagBits(1)' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_AES_GCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_GCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_AES_CCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_CCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new' );
    myis( $obj->set_pNonce('1'), CKR_OK, '$obj->set_pNonce("1")' );
    myis( $obj->set_pNonce('1'), CKR_OK, '$obj->set_pNonce("1")' );
    myis( $obj->set_pNonce(undef), CKR_OK, '$obj->set_pNonce(undef)' );
    myis( $obj->set_pNonce('1'), CKR_OK, '$obj->set_pNonce("1")' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myis( $obj->set_pAAD(undef), CKR_OK, '$obj->set_pAAD(undef)' );
    myis( $obj->set_pAAD('1'), CKR_OK, '$obj->set_pAAD("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_AES_CCM_PARAMS->new, 'Crypt::PKCS11::CK_AES_CCM_PARAMSPtr', 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new' );
    myis( $obj->set_ulCounterBits(1), CKR_OK, '$obj->set_ulCounterBits(1)' );
    myis( $obj->set_ulCounterBits(1), CKR_OK, '$obj->set_ulCounterBits(1)' );
    myis( $obj->set_cb('12345678123456789'), CKR_ARGUMENTS_BAD, '$obj->set_cb("12345678123456789")' );
    myis( $obj->set_cb(-1), CKR_ARGUMENTS_BAD, '$obj->set_cb(-1)' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myis( $obj->set_cb(undef), CKR_OK, '$obj->set_cb(undef)' );
    myis( $obj->set_cb('1234567812345678'), CKR_OK, '$obj->set_cb("1234567812345678")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj->set_iv('12345678123456789'), CKR_ARGUMENTS_BAD, '$obj->set_iv("12345678123456789")' );
    myis( $obj->set_iv(-1), CKR_ARGUMENTS_BAD, '$obj->set_iv(-1)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv(undef), CKR_OK, '$obj->set_iv(undef)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData(undef), CKR_OK, '$obj->set_pData(undef)' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myok( $bytes = $obj->toBytes, '$obj->toBytes' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myisa_ok( $obj = Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj->set_iv('12345678123456789'), CKR_ARGUMENTS_BAD, '$obj->set_iv("12345678123456789")' );
    myis( $obj->set_iv(-1), CKR_ARGUMENTS_BAD, '$obj->set_iv(-1)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_iv(undef), CKR_OK, '$obj->set_iv(undef)' );
    myis( $obj->set_iv('1234567812345678'), CKR_OK, '$obj->set_iv("1234567812345678")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myis( $obj->set_pData(undef), CKR_OK, '$obj->set_pData(undef)' );
    myis( $obj->set_pData('1'), CKR_OK, '$obj->set_pData("1")' );
    myisa_ok( $obj2 = Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMSPtr', 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );
    myis( $obj2->fromBytes($bytes), CKR_OK, '$obj2->fromBytes($bytes)' );

    myis( Crypt::PKCS11::CK_VERSION->new->set_major(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_VERSION->new->set_major(-1)' );
    myis( Crypt::PKCS11::CK_VERSION->new->set_minor(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_VERSION->new->set_minor(-1)' );
    myis( Crypt::PKCS11::CK_MECHANISM->new->set_mechanism(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_MECHANISM->new->set_mechanism(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_hashAlg(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_hashAlg(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_mgf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_mgf(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_source(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_source(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_hashAlg(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_hashAlg(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_mgf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_mgf(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_sLen(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS->new->set_sLen(-1)' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_hPrivateData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_hPrivateData(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_hPrivateData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_hPrivateData(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_publicKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_publicKey(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_hPrivateData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_hPrivateData(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_kdf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_kdf(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_hPrivateData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_hPrivateData(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_publicKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_publicKey(-1)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_isSender(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_isSender(-1)' );
    myis( Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->set_ulEffectiveBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC2_CBC_PARAMS->new->set_ulEffectiveBits(-1)' );
    myis( Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new->set_ulEffectiveBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS->new->set_ulEffectiveBits(-1)' );
    myis( Crypt::PKCS11::CK_RC5_PARAMS->new->set_ulWordsize(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_PARAMS->new->set_ulWordsize(-1)' );
    myis( Crypt::PKCS11::CK_RC5_PARAMS->new->set_ulRounds(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_PARAMS->new->set_ulRounds(-1)' );
    myis( Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_ulWordsize(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_ulWordsize(-1)' );
    myis( Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_ulRounds(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_ulRounds(-1)' );
    myis( Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->set_ulWordsize(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->set_ulWordsize(-1)' );
    myis( Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->set_ulRounds(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS->new->set_ulRounds(-1)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_ulIteration(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_ulIteration(-1)' );
    myis( Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_bBC(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_bBC(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hClientMacSecret(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hClientMacSecret(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hServerMacSecret(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hServerMacSecret(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hClientKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hClientKey(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hServerKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT->new->set_hServerKey(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulMacSizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulMacSizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulKeySizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulKeySizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulIVSizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_ulIVSizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_bIsExport(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS->new->set_bIsExport(-1)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->set_DigestMechanism(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS->new->set_DigestMechanism(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_DigestMechanism(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_DigestMechanism(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->set_hMacSecret(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->set_hMacSecret(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->set_hKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT->new->set_hKey(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_DigestMechanism(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_DigestMechanism(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulMacSizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulMacSizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulKeySizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulKeySizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulIVSizeInBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulIVSizeInBits(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulSequenceNumber(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_ulSequenceNumber(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_bIsExport(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS->new->set_bIsExport(-1)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_certificateHandle(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_certificateHandle(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_saltSource(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_saltSource(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_iterations(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_iterations(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_prf(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_prf(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(-1)' );
    myis( Crypt::PKCS11::CK_OTP_PARAM->new->set_type(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_OTP_PARAM->new->set_type(-1)' );
    myis( Crypt::PKCS11::CK_OTP_PARAMS->new->set_ulCount(-1), CKR_FUNCTION_NOT_SUPPORTED, 'Crypt::PKCS11::CK_OTP_PARAMS->new->set_ulCount(-1)' );
    myis( Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->set_ulCount(-1), CKR_FUNCTION_NOT_SUPPORTED, 'Crypt::PKCS11::CK_OTP_SIGNATURE_INFO->new->set_ulCount(-1)' );
    myis( Crypt::PKCS11::CK_KIP_PARAMS->new->set_hKey(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KIP_PARAMS->new->set_hKey(-1)' );
    myis( Crypt::PKCS11::CK_AES_CTR_PARAMS->new->set_ulCounterBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_CTR_PARAMS->new->set_ulCounterBits(-1)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_ulIvBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_ulIvBits(-1)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_ulTagBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_ulTagBits(-1)' );
    myis( Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->set_ulCounterBits(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS->new->set_ulCounterBits(-1)' );

    myis( Crypt::PKCS11::CK_MECHANISM->new->set_pParameter(undef), CKR_OK, 'Crypt::PKCS11::CK_MECHANISM->new->set_pParameter(undef)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_pSourceData(undef), CKR_OK, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_pSourceData(undef)' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pSharedData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pSharedData(undef)' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pSharedData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pSharedData(undef)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData2(undef), CKR_OK, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData2(undef)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pSharedData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pSharedData(undef)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData2(undef), CKR_OK, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData2(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pOtherInfo(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pOtherInfo(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pOtherInfo(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pOtherInfo(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData2(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData2(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pOtherInfo(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pOtherInfo(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData2(undef), CKR_OK, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData2(undef)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomA(undef), CKR_OK, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomA(undef)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomB(undef), CKR_OK, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomB(undef)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_pIv(undef), CKR_OK, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_pIv(undef)' );
    myis( Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef), CKR_OK, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef)' );
    myis( Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef), CKR_OK, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPassword(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPassword(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPublicData(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pRandomA(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pRandomA(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPrimeP(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPrimeP(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pBaseG(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pBaseG(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pSubprimeQ(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pSubprimeQ(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldWrappedX(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldWrappedX(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPassword(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPassword(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPublicData(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldRandomA(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldRandomA(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPassword(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPassword(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPublicData(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPublicData(undef)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewRandomA(undef), CKR_OK, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewRandomA(undef)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pInitVector(undef), CKR_OK, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pInitVector(undef)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pPassword(undef), CKR_OK, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pPassword(undef)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pSalt(undef), CKR_OK, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pSalt(undef)' );
    myis( Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_pX(undef), CKR_OK, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_pX(undef)' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pClientRandom(undef), CKR_OK, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pClientRandom(undef)' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pServerRandom(undef), CKR_OK, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pServerRandom(undef)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pSeed(undef), CKR_OK, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pSeed(undef)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pLabel(undef), CKR_OK, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pLabel(undef)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(undef), CKR_OK, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(undef)' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pClientRandom(undef), CKR_OK, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pClientRandom(undef)' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pServerRandom(undef), CKR_OK, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pServerRandom(undef)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pSeed(undef), CKR_OK, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pSeed(undef)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pLabel(undef), CKR_OK, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pLabel(undef)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(undef), CKR_OK, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(undef)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pContentType(undef), CKR_OK, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pContentType(undef)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequestedAttributes(undef), CKR_OK, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequestedAttributes(undef)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequiredAttributes(undef), CKR_OK, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequiredAttributes(undef)' );
    myis( Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->set_pData(undef), CKR_OK, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->set_pData(undef)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pSaltSourceData(undef), CKR_OK, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pSaltSourceData(undef)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPrfData(undef), CKR_OK, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPrfData(undef)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(undef), CKR_OK, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(undef)' );
    myis( Crypt::PKCS11::CK_OTP_PARAM->new->set_pValue(undef), CKR_OK, 'Crypt::PKCS11::CK_OTP_PARAM->new->set_pValue(undef)' );
    myis( Crypt::PKCS11::CK_KIP_PARAMS->new->set_pSeed(undef), CKR_OK, 'Crypt::PKCS11::CK_KIP_PARAMS->new->set_pSeed(undef)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pIv(undef), CKR_OK, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pIv(undef)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pAAD(undef), CKR_OK, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pAAD(undef)' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pNonce(undef), CKR_OK, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pNonce(undef)' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pAAD(undef), CKR_OK, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pAAD(undef)' );
    myis( Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef), CKR_OK, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef)' );
    myis( Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef), CKR_OK, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(undef)' );

    myis( Crypt::PKCS11::CK_MECHANISM->new->set_pParameter(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_MECHANISM->new->set_pParameter(-1)' );
    myis( Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_pSourceData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS->new->set_pSourceData(-1)' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pSharedData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pSharedData(-1)' );
    myis( Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pSharedData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pSharedData(-1)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData2(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS->new->set_pPublicData2(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pSharedData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pSharedData(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData2(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS->new->set_pPublicData2(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pOtherInfo(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pOtherInfo(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pOtherInfo(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pOtherInfo(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData2(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS->new->set_pPublicData2(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pOtherInfo(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pOtherInfo(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData2(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS->new->set_pPublicData2(-1)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomA(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomA(-1)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomB(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pRandomB(-1)' );
    myis( Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEA_DERIVE_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_pIv(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_RC5_CBC_PARAMS->new->set_pIv(-1)' );
    myis( Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1)' );
    myis( Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPassword(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPublicData(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pRandomA(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pRandomA(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPrimeP(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pPrimeP(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pBaseG(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pBaseG(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pSubprimeQ(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS->new->set_pSubprimeQ(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldWrappedX(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldWrappedX(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPassword(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldPublicData(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldRandomA(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pOldRandomA(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPassword(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPublicData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewPublicData(-1)' );
    myis( Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewRandomA(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS->new->set_pNewRandomA(-1)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pInitVector(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pInitVector(-1)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pPassword(-1)' );
    myis( Crypt::PKCS11::CK_PBE_PARAMS->new->set_pSalt(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PBE_PARAMS->new->set_pSalt(-1)' );
    myis( Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_pX(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS->new->set_pX(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pClientRandom(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pClientRandom(-1)' );
    myis( Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pServerRandom(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_SSL3_RANDOM_DATA->new->set_pServerRandom(-1)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pSeed(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pSeed(-1)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pLabel(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pLabel(-1)' );
    myis( Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_TLS_PRF_PARAMS->new->set_pOutput(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pClientRandom(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pClientRandom(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pServerRandom(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_RANDOM_DATA->new->set_pServerRandom(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pSeed(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pSeed(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pLabel(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pLabel(-1)' );
    myis( Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_WTLS_PRF_PARAMS->new->set_pOutput(-1)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pContentType(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pContentType(-1)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequestedAttributes(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequestedAttributes(-1)' );
    myis( Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequiredAttributes(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CMS_SIG_PARAMS->new->set_pRequiredAttributes(-1)' );
    myis( Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->set_pData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA->new->set_pData(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pSaltSourceData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pSaltSourceData(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPrfData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPrfData(-1)' );
    myis( Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS->new->set_pPassword(-1)' );
    myis( Crypt::PKCS11::CK_OTP_PARAM->new->set_pValue(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_OTP_PARAM->new->set_pValue(-1)' );
    myis( Crypt::PKCS11::CK_KIP_PARAMS->new->set_pSeed(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_KIP_PARAMS->new->set_pSeed(-1)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pIv(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pIv(-1)' );
    myis( Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pAAD(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_GCM_PARAMS->new->set_pAAD(-1)' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pNonce(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pNonce(-1)' );
    myis( Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pAAD(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_AES_CCM_PARAMS->new->set_pAAD(-1)' );
    myis( Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1)' );
    myis( Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1), CKR_ARGUMENTS_BAD, 'Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS->new->set_pData(-1)' );
}

#{
#    local $SIG{__WARN__} = sub {};
#    my $sub = *Crypt::PKCS11::XS::new{CODE};
#    *Crypt::PKCS11::XS::new = sub ($) {};
#    $@ = undef; eval { Crypt::PKCS11->new; };
#    myok( $@, '*Crypt::PKCS11::XS::new undef' );
#    *Crypt::PKCS11::XS::new = $sub;
#}

# sub mytests
}

BEGIN {
    eval '
        use Test::LeakTrace;
        $HAVE_LEAKTRACE = 1;
    ';
}

mytests;
if ($HAVE_LEAKTRACE and $ENV{TEST_LEAKTRACE}) {
    $LEAK_TESTING = 1;
    leaks_cmp_ok { mytests; } '<', 1;
}
done_testing;
