#!perl
use strict;
use vars qw( $DEBUG );
$DEBUG = exists( $ENV{AUTHOR_TESTING} ) ? $ENV{AUTHOR_TESTING} : 0;

print "1..3\n";

use Data::Pretty qw(dump); 
local $Data::Pretty::DEBUG = $DEBUG;

$a = 42;
bless \$a, "Foo";

my $d = dump($a);

print "$d\n";
print "not " unless $d eq q(do {
  my $a = 42;
  bless \$a, "Foo";
  $a;
});
print "ok 1\n";

$d = dump(\$a);
print "$d\n";
print "not " unless $d eq q(bless(do{\\(my $o = 42)}, "Foo"));
print "ok 2\n";

$d = dump(\\$a);
print "$d\n";
print "not " unless $d eq q(\\bless(do{\\(my $o = 42)}, "Foo"));
print "ok 3\n";
