#!/usr/bin/perl

package eBay::API::XML::Call::AddDisputeResponse;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddDisputeResponse.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddDisputeResponse

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddDisputeResponse inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::AddDisputeResponse::AddDisputeResponseRequestType;
use eBay::API::XML::Call::AddDisputeResponse::AddDisputeResponseResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'AddDisputeResponse';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddDisputeResponse::AddDisputeResponseRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::AddDisputeResponse::AddDisputeResponseResponseType';
}

#
# input properties
#

=head2 setDisputeActivity()

The type of activity the seller is taking on the dispute.
The allowed value is determined by the current value of
DisputeState, returned by GetDispute or GetUserDisputes.
Some values are for Unpaid Item disputes and some are for Item
Not Received disputes.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=UnpaidItemDisputes
Title: Unpaid Item Disputes
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=ItemNotReceivedDisputes
Title: Item Not Received Disputes


  RequiredInput: Conditionally
#    Argument: 'ns:DisputeActivityCodeType'

=cut
       
sub setDisputeActivity {
   my $self   = shift;
   my $sDisputeActivity = shift;
   $self->getRequestDataType()->setDisputeActivity($sDisputeActivity);
}

=head2 setDisputeID()

The unique identifier of the dispute,
returned when the dispute was created.

  RequiredInput: Yes
#    Argument: 'ns:DisputeIDType'

=cut
       
sub setDisputeID {
   my $self   = shift;
   my $pDisputeID = shift;
   $self->getRequestDataType()->setDisputeID($pDisputeID);
}

=head2 setMessageText()

The text of a comment or response being posted to the dispute. Required
when DisputeActivity is SellerAddInformation, SellerComment, or
SellerPaymentNotReceived; otherwise, optional.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setMessageText {
   my $self   = shift;
   my $sMessageText = shift;
   $self->getRequestDataType()->setMessageText($sMessageText);
}

=head2 setShipmentTrackNumber()

The shipper's tracking number for the item being shipped. Required
if DisputeActivity is SellerShippedItem; otherwise, optional.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setShipmentTrackNumber {
   my $self   = shift;
   my $sShipmentTrackNumber = shift;
   $self->getRequestDataType()->setShipmentTrackNumber($sShipmentTrackNumber);
}

=head2 setShippingCarrierUsed()

The shipping carrier used for the item in dispute. Required if DisputeActivity
is SellerShippedItem; otherwise, optional.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setShippingCarrierUsed {
   my $self   = shift;
   my $sShippingCarrierUsed = shift;
   $self->getRequestDataType()->setShippingCarrierUsed($sShippingCarrierUsed);
}

=head2 setShippingTime()

The date the item under dispute was shipped. Required if DisputeActivity
is SellerShippedItem; otherwise, optional.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut
       
sub setShippingTime {
   my $self   = shift;
   my $sShippingTime = shift;
   $self->getRequestDataType()->setShippingTime($sShippingTime);
}



#
# output properties
#





1;   
