/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata.sql;

import java.util.Date;

public final class TypeMapper {
    private static final TypeMapper[] TYPES = new TypeMapper[]{new TypeMapper(Boolean.class, 16, "BOOLEAN"), new TypeMapper(Date.class, 93, "TIMESTAMP"), new TypeMapper(Double.class, 8, "DOUBLE PRECISION"), new TypeMapper(Float.class, 7, "REAL"), new TypeMapper(Long.class, -5, "BIGINT"), new TypeMapper(Integer.class, 4, "INTEGER"), new TypeMapper(Short.class, 5, "SMALLINT"), new TypeMapper(Byte.class, -6, "SMALLINT"), new TypeMapper(Number.class, 3, "DECIMAL")};
    private final Class<?> classe;
    private final int type;
    private final String keyword;

    private TypeMapper(Class<?> clazz, int n, String string) {
        this.classe = clazz;
        this.type = n;
        this.keyword = string;
    }

    public static String keywordFor(Class<?> clazz) {
        if (clazz != null) {
            for (TypeMapper typeMapper : TYPES) {
                if (!typeMapper.classe.isAssignableFrom(clazz)) continue;
                return typeMapper.keyword;
            }
        }
        return null;
    }

    public static Class<?> toJavaType(int n) {
        for (TypeMapper typeMapper : TYPES) {
            if (typeMapper.type != n) continue;
            return typeMapper.classe;
        }
        return null;
    }
}

