/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.utils;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.graph.AdjacencyEdge;
import at.ac.tuwien.dbai.pdfwrap.utils.Utils;

public class SegmentUtils {
    public static boolean horizMinIntersect(GenericSegment seg1, GenericSegment seg2, float percent) {
        float intersectionWidth = seg1.getWidth() * percent;
        if (seg2.getWidth() < seg1.getWidth()) {
            intersectionWidth = seg2.getWidth() * percent;
        }
        if (seg1.getX1() >= seg2.getX1() && seg1.getX1() <= seg2.getX2()) {
            return Utils.minimum(seg1.getX2(), seg2.getX2()) - seg1.getX1() >= intersectionWidth;
        }
        if (seg2.getX1() >= seg1.getX1() && seg2.getX1() <= seg1.getX2()) {
            return Utils.minimum(seg1.getX2(), seg2.getX2()) - seg2.getX1() >= intersectionWidth;
        }
        return false;
    }

    public static boolean horizIntersect(GenericSegment seg1, GenericSegment seg2) {
        return seg1.getX1() >= seg2.getX1() && seg1.getX1() <= seg2.getX2() || seg2.getX1() >= seg1.getX1() && seg2.getX1() <= seg1.getX2();
    }

    public static boolean horizIntersect(GenericSegment seg1, float sx1, float sx2) {
        GenericSegment seg2 = new GenericSegment(sx1, sx2, -1.0f, -1.0f);
        return seg1.getX1() >= seg2.getX1() && seg1.getX1() <= seg2.getX2() || seg2.getX1() >= seg1.getX1() && seg2.getX1() <= seg1.getX2();
    }

    public static boolean horizIntersect(GenericSegment seg, float val) {
        return seg.getX1() <= val && seg.getX2() >= val || seg.getX1() >= val && seg.getX2() <= val;
    }

    public static boolean vertMinIntersect(GenericSegment seg1, GenericSegment seg2, float percent) {
        float intersectionHeight = seg1.getHeight() * percent;
        if (seg2.getHeight() < seg1.getHeight()) {
            intersectionHeight = seg2.getHeight() * percent;
        }
        if (seg1.getY1() >= seg2.getY1() && seg1.getY1() <= seg2.getY2()) {
            return Utils.minimum(seg1.getY2(), seg2.getY2()) - seg1.getY1() >= intersectionHeight;
        }
        if (seg2.getY1() >= seg1.getY1() && seg2.getY1() <= seg1.getY2()) {
            return Utils.minimum(seg1.getY2(), seg2.getY2()) - seg2.getY1() >= intersectionHeight;
        }
        return false;
    }

    public static boolean vertIntersect(GenericSegment seg1, GenericSegment seg2) {
        return seg1.getY1() >= seg2.getY1() && seg1.getY1() <= seg2.getY2() || seg2.getY1() >= seg1.getY1() && seg2.getY1() <= seg1.getY2();
    }

    public static boolean vertIntersect(GenericSegment seg1, float sy1, float sy2) {
        GenericSegment seg2 = new GenericSegment(-1.0f, -1.0f, sy1, sy2);
        return seg1.getY1() >= seg2.getY1() && seg1.getY1() <= seg2.getY2() || seg2.getY1() >= seg1.getY1() && seg2.getY1() <= seg1.getY2();
    }

    public static boolean vertIntersect(GenericSegment seg, float val) {
        return seg.getY1() <= val && seg.getY2() >= val || seg.getY1() >= val && seg.getY1() <= val;
    }

    public static boolean intersects(GenericSegment seg1, GenericSegment seg2) {
        return SegmentUtils.horizIntersect(seg1, seg2) && SegmentUtils.vertIntersect(seg1, seg2);
    }

    public static boolean intersects(AdjacencyEdge<? extends GenericSegment> e1, AdjacencyEdge<? extends GenericSegment> e2) {
        float low2;
        float hi2;
        float low1;
        float hi1;
        if (!e1.isHorizontal() && e2.isHorizontal() || e1.isHorizontal() && !e2.isHorizontal()) {
            return false;
        }
        switch (e1.getDirection()) {
            case 0: {
                hi1 = e1.getNodeFrom().getX1();
                low1 = e1.getNodeTo().getX2();
                break;
            }
            case 1: {
                hi1 = e1.getNodeTo().getX1();
                low1 = e1.getNodeFrom().getX2();
                break;
            }
            case 2: {
                hi1 = e1.getNodeTo().getY1();
                low1 = e1.getNodeFrom().getY2();
                break;
            }
            case 3: {
                hi1 = e1.getNodeFrom().getY1();
                low1 = e1.getNodeTo().getY2();
                break;
            }
            default: {
                return false;
            }
        }
        switch (e2.getDirection()) {
            case 0: {
                hi2 = e2.getNodeFrom().getX1();
                low2 = e2.getNodeTo().getX2();
                break;
            }
            case 1: {
                hi2 = e2.getNodeTo().getX1();
                low2 = e2.getNodeFrom().getX2();
                break;
            }
            case 2: {
                hi2 = e2.getNodeTo().getY1();
                low2 = e2.getNodeFrom().getY2();
                break;
            }
            case 3: {
                hi2 = e2.getNodeFrom().getY1();
                low2 = e2.getNodeTo().getY2();
                break;
            }
            default: {
                return false;
            }
        }
        return low1 >= low2 && low1 <= hi2 || hi1 >= low2 && hi1 <= hi2 || low1 < low2 && hi1 > hi2;
    }
}

