package AWS::Lambda;
use 5.026000;
use strict;
use warnings;

our $VERSION = "0.0.21";

# the context of Lambda Function
our $context;

# This list is auto generated by authors/update-aws-lambda.pl; DO NOT EDIT
our $LAYERS = {
    '5.32' => {
        'af-south-1' => {
            runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-east-1' => {
            runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-northeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-northeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-south-1' => {
            runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-southeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ap-southeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'ca-central-1' => {
            runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'eu-central-1' => {
            runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'eu-south-1' => {
            runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'eu-west-1' => {
            runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'eu-west-2' => {
            runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'eu-west-3' => {
            runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'me-south-1' => {
            runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'sa-east-1' => {
            runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'us-east-1' => {
            runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'us-east-2' => {
            runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'us-west-1' => {
            runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
        'us-west-2' => {
            runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-32-runtime:1",
            runtime_version => 1,
            paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-32-paws:1",
            paws_version    => 1,
        },
    },
    '5.30' => {
        'af-south-1' => {
            runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-30-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-30-paws:2",
            paws_version    => 2,
        },
        'ap-east-1' => {
            runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ap-northeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ap-northeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ap-south-1' => {
            runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ap-southeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ap-southeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'ca-central-1' => {
            runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'eu-central-1' => {
            runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'eu-south-1' => {
            runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-30-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-30-paws:2",
            paws_version    => 2,
        },
        'eu-west-1' => {
            runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'eu-west-2' => {
            runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'eu-west-3' => {
            runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'me-south-1' => {
            runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-30-runtime:7",
            runtime_version => 7,
            paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-30-paws:5",
            paws_version    => 5,
        },
        'sa-east-1' => {
            runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'us-east-1' => {
            runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'us-east-2' => {
            runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'us-west-1' => {
            runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
        'us-west-2' => {
            runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-30-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-30-paws:6",
            paws_version    => 6,
        },
    },
    '5.28' => {
        'af-south-1' => {
            runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-28-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-28-paws:2",
            paws_version    => 2,
        },
        'ap-east-1' => {
            runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-28-runtime:8",
            runtime_version => 8,
            paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ap-northeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ap-northeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ap-south-1' => {
            runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ap-southeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ap-southeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'ca-central-1' => {
            runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'eu-central-1' => {
            runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'eu-south-1' => {
            runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-28-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-28-paws:2",
            paws_version    => 2,
        },
        'eu-west-1' => {
            runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'eu-west-2' => {
            runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'eu-west-3' => {
            runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'me-south-1' => {
            runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-28-runtime:6",
            runtime_version => 6,
            paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-28-paws:4",
            paws_version    => 4,
        },
        'sa-east-1' => {
            runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'us-east-1' => {
            runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'us-east-2' => {
            runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'us-west-1' => {
            runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
        'us-west-2' => {
            runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-28-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-28-paws:5",
            paws_version    => 5,
        },
    },
    '5.26' => {
        'af-south-1' => {
            runtime_arn     => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-26-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:af-south-1:445285296882:layer:perl-5-26-paws:2",
            paws_version    => 2,
        },
        'ap-east-1' => {
            runtime_arn     => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-26-runtime:9",
            runtime_version => 9,
            paws_arn        => "arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ap-northeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ap-northeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ap-south-1' => {
            runtime_arn     => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ap-southeast-1' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ap-southeast-2' => {
            runtime_arn     => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'ca-central-1' => {
            runtime_arn     => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'eu-central-1' => {
            runtime_arn     => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'eu-south-1' => {
            runtime_arn     => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-26-runtime:2",
            runtime_version => 2,
            paws_arn        => "arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-26-paws:2",
            paws_version    => 2,
        },
        'eu-west-1' => {
            runtime_arn     => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-26-runtime:16",
            runtime_version => 16,
            paws_arn        => "arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-26-paws:6",
            paws_version    => 6,
        },
        'eu-west-2' => {
            runtime_arn     => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'eu-west-3' => {
            runtime_arn     => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'me-south-1' => {
            runtime_arn     => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-26-runtime:6",
            runtime_version => 6,
            paws_arn        => "arn:aws:lambda:me-south-1:445285296882:layer:perl-5-26-paws:4",
            paws_version    => 4,
        },
        'sa-east-1' => {
            runtime_arn     => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'us-east-1' => {
            runtime_arn     => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-east-1:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'us-east-2' => {
            runtime_arn     => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-east-2:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'us-west-1' => {
            runtime_arn     => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-west-1:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
        'us-west-2' => {
            runtime_arn     => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-26-runtime:15",
            runtime_version => 15,
            paws_arn        => "arn:aws:lambda:us-west-2:445285296882:layer:perl-5-26-paws:5",
            paws_version    => 5,
        },
    },
};


sub get_layer_info {
    my ($version, $region) = @_;
    return $LAYERS->{$version}{$region};
}

sub print_runtime_arn {
    my ($version, $region) = @_;
    print $LAYERS->{$version}{$region}{runtime_arn};
}

sub print_paws_arn {
    my ($version, $region) = @_;
    print $LAYERS->{$version}{$region}{paws_arn};
}

1;
__END__

=encoding utf-8

=head1 NAME

AWS::Lambda - It's Perl support for AWS Lambda Custom Runtime.

=head1 SYNOPSIS

Save the following Perl script as C<handler.pl>.

    sub handle {
        my ($payload, $context) = @_;
        return $payload;
    }

and then, zip the script.

    zip handler.zip handler.pl

Finally, create new function using awscli.

    aws --region "$REGION" --profile "$PROFILE" lambda create-function \
        --function-name "hello-perl" \
        --zip-file "fileb://handler.zip" \
        --handler "handler.handle" \
        --runtime provided \
        --role arn:aws:iam::xxxxxxxxxxxx:role/service-role/lambda-custom-runtime-perl-role \
        --layers "arn:aws:lambda:$REGION:445285296882:layer:perl-5-32-runtime:1"

=head1 DESCRIPTION

This package makes it easy to run AWS Lambda Functions written in Perl.

=head2 Use Prebuild Public Lambda Layer

=over

=item 1

Login to your AWS Account and go to the Lambda Console.

=item 2

Create a new function and give it a name and an IAM Role.

=item 3

For the "Runtime" selection, select B<Use custom runtime in function code or layer>.

=item 4

In the "Designer" section of your function dashboard, select the B<Layers> box.

=item 5

Scroll down to the "Referenced Layers" section and click B<Add a layer>.

=item 6

Select the B<Provide a layer version ARN> option, then copy/paste the Layer ARN for your region.

=item 7

Click the B<Add> button.

=item 8

Click B<Save> in the upper right.

=item 9

Upload your code and start using Perl in AWS Lambda!

=back

You can get the layer ARN in your script by using C<get_layer_info>.

    use AWS::Lambda;
    my $info = AWS::Lambda::get_layer_info(
        "5.32",      # Perl Version
        "us-east-1", # Region
    );
    say $info->{runtime_arn};     # arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-runtime:1
    say $info->{runtime_version}; # 1
    say $info->{paws_arn}         # arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-paws:1
    say $info->{paws_version}     # 1,

Or, you can use following one-liner.

    perl -MAWS::Lambda -e 'AWS::Lambda::print_runtime_arn("5.32", "us-east-1")'
    perl -MAWS::Lambda -e 'AWS::Lambda::print_paws_arn("5.32", "us-east-1")'

All available layer ARN list is here.

=over

=item Perl 5.32

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-32-runtime:1>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-32-runtime:1>

=back

=item Perl 5.30

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-30-runtime:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-30-runtime:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-30-runtime:7>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-30-runtime:9>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-30-runtime:9>

=back

=item Perl 5.28

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-28-runtime:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-28-runtime:8>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-28-runtime:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-28-runtime:6>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-28-runtime:15>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-28-runtime:15>

=back

=item Perl 5.26

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-26-runtime:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-26-runtime:9>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-26-runtime:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-26-runtime:16>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-26-runtime:6>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-26-runtime:15>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-26-runtime:15>

=back

=back

=head2 Use Prebuild Zip Archive

=over

=item 1

Login to your AWS Account and go to the Lambda Console.

=item 2

Create a new layer and give it a name.

=item 3

For the "Code entry type" selection, select B<Upload a file from Amazon S3>.

=item 4

In the "License" section, input L<https://github.com/shogo82148/p5-aws-lambda/blob/master/LICENSE>.

=item 5

Click B<Create> button.

=item 6

Use the layer created. For detail, see Use Prebuild Public Lambda Layer section.

=back

URLs for Zip archive are here.

C<https://shogo82148-lambda-perl-runtime-$REGION.s3.amazonaws.com/perl-$VERSION-runtime.zip>

=head2 Run in Local using Docker

L<https://hub.docker.com/r/shogo82148/p5-aws-lambda> is pre-build docker image based on L<https://hub.docker.com/r/lambci/lambda/>

    # Install the dependency.
    docker run --rm -v $(PWD):/var/task shogo82148/p5-aws-lambda:build-5.32 \
        cpanm --notest --local-lib extlocal --no-man-pages --installdeps .

    # run an event.
    docker run --rm -v $(PWD):/var/task shogo82148/p5-aws-lambda:5.32 \
        handler.handle '{"some":"event"}'

=head2 AWS XRay SUPPORT

L<AWS X-Ray|https://aws.amazon.com/xray/> is a service that collects data about requests that your application serves.
You can trace AWS Lambda requests and sends segment data with pre-install module L<AWS::XRay>.

    use utf8;
    use warnings;
    use strict;
    use AWS::XRay qw/ capture /;

    sub handle {
        my ($payload, $context) = @_;
        capture "myApp" => sub {
            capture "nested" => sub {
                # do something ...
            };
        };
        capture "another" => sub {
            # do something ...
        };
        return;
    }

    1;


=head1 Paws SUPPORT

If you want to call AWS API from your Lambda function,
you can use a pre-build Lambda Layer for L<Paws> - A Perl SDK for AWS (Amazon Web Services) APIs.

=head2 Use Prebuild Public Lambda Layer

Add the perl-runtime layer and the perl-paws layer into your lambda function.

    aws --region "$REGION" --profile "$PROFILE" lambda create-function \
        --function-name "hello-perl" \
        --zip-file "fileb://handler.zip" \
        --handler "handler.handle" \
        --runtime provided \
        --role arn:aws:iam::xxxxxxxxxxxx:role/service-role/lambda-custom-runtime-perl-role \
        --layers \
            "arn:aws:lambda:$REGION:445285296882:layer:perl-5-32-runtime:1" \
            "arn:aws:lambda:$REGION:445285296882:layer:perl-5-32-paws:1"

Now, you can use L<Paws> to call AWS API from your Lambda function.

    use Paws;
    my $obj = Paws->service('...');
    my $res = $obj->MethodCall(Arg1 => $val1, Arg2 => $val2);
    print $res->AttributeFromResult;

All available layer ARN list is here.

=over

=item Perl 5.32

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-32-paws:1>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-32-paws:1>

=back

=item Perl 5.30

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-30-paws:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-30-paws:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-30-paws:5>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-30-paws:6>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-30-paws:6>

=back

=item Perl 5.28

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-28-paws:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-28-paws:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-28-paws:4>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-28-paws:5>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-28-paws:5>

=back

=item Perl 5.26

=over

=item C<arn:aws:lambda:af-south-1:445285296882:layer:perl-5-26-paws:2>

=item C<arn:aws:lambda:ap-east-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ap-northeast-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ap-northeast-2:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ap-south-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ap-southeast-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ap-southeast-2:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:ca-central-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:eu-central-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:eu-south-1:445285296882:layer:perl-5-26-paws:2>

=item C<arn:aws:lambda:eu-west-1:445285296882:layer:perl-5-26-paws:6>

=item C<arn:aws:lambda:eu-west-2:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:eu-west-3:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:me-south-1:445285296882:layer:perl-5-26-paws:4>

=item C<arn:aws:lambda:sa-east-1:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:us-east-1:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:us-east-2:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:us-west-1:445285296882:layer:perl-5-26-paws:5>

=item C<arn:aws:lambda:us-west-2:445285296882:layer:perl-5-26-paws:5>

=back

=back

URLs for Zip archive are here.

C<https://shogo82148-lambda-perl-runtime-$REGION.s3.amazonaws.com/perl-$VERSION-paws.zip>

=head2 Run in Local using Docker

L<https://hub.docker.com/r/shogo82148/p5-aws-lambda> is pre-build docker image based on L<https://hub.docker.com/r/lambci/lambda/>

    # Install the dependency.
    docker run --rm -v $(PWD):/var/task shogo82148/p5-aws-lambda:build-5.32-paws \
        cpanm --notest --local-lib extlocal --no-man-pages --installdeps .

    # run an event.
    docker run --rm -v $(PWD):/var/task shogo82148/p5-aws-lambda:5.32-paws \
        handler.handle '{"some":"event"}'

=head1 CREATE MODULE LAYER

To create custom module layer such as the Paws Layer,
install the modules into C</opt/lib/perl5/site_perl> in the layer.

    # Create Some::Module Layer
    docker run --rm \
        -v $(PWD):/var/task \
        -v $(PATH_TO_LAYER_DIR)/lib/perl5/site_perl:/opt/lib/perl5/site_perl \
        shogo82148/p5-aws-lambda:build-5.32 \
        cpanm --notest --no-man-pages Some::Module
    cd $(PATH_TO_LAYER_DIR) && zip -9 -r $(PATH_TO_DIST)/some-module.zip .

=head1 SEE ALSO

=over

=item L<AWS::Lambda::Bootstrap>

=item L<AWS::Lambda::Context>

=item L<AWS::Lambda::PSGI>

=item L<Paws>

=item L<AWS::XRay>

=back

=head1 LICENSE

The MIT License (MIT)

Copyright (C) Ichinose Shogo.

=head1 AUTHOR

Ichinose Shogo E<lt>shogo82148@gmail.comE<gt>

=cut
