
package Paws::Athena::ListPreparedStatements;
  use Moose;
  has MaxResults => (is => 'ro', isa => 'Int');
  has NextToken => (is => 'ro', isa => 'Str');
  has WorkGroup => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListPreparedStatements');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Athena::ListPreparedStatementsOutput');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::ListPreparedStatements - Arguments for method ListPreparedStatements on L<Paws::Athena>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListPreparedStatements on the
L<Amazon Athena|Paws::Athena> service. Use the attributes of this class
as arguments to method ListPreparedStatements.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListPreparedStatements.

=head1 SYNOPSIS

    my $athena = Paws->service('Athena');
    my $ListPreparedStatementsOutput = $athena->ListPreparedStatements(
      WorkGroup  => 'MyWorkGroupName',
      MaxResults => 1,                   # OPTIONAL
      NextToken  => 'MyToken',           # OPTIONAL
    );

    # Results:
    my $NextToken          = $ListPreparedStatementsOutput->NextToken;
    my $PreparedStatements = $ListPreparedStatementsOutput->PreparedStatements;

    # Returns a L<Paws::Athena::ListPreparedStatementsOutput> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/athena/ListPreparedStatements>

=head1 ATTRIBUTES


=head2 MaxResults => Int

The maximum number of results to return in this request.



=head2 NextToken => Str

A token generated by the Athena service that specifies where to
continue pagination if a previous request was truncated. To obtain the
next set of pages, pass in the C<NextToken> from the response object of
the previous page call.



=head2 B<REQUIRED> WorkGroup => Str

The workgroup to list the prepared statements for.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListPreparedStatements in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

