# Generated by default/object.tt
package Paws::Macie2::S3JobDefinition;
  use Moose;
  has BucketCriteria => (is => 'ro', isa => 'Paws::Macie2::S3BucketCriteriaForJob', request_name => 'bucketCriteria', traits => ['NameInRequest']);
  has BucketDefinitions => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::S3BucketDefinitionForJob]', request_name => 'bucketDefinitions', traits => ['NameInRequest']);
  has Scoping => (is => 'ro', isa => 'Paws::Macie2::Scoping', request_name => 'scoping', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::S3JobDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::S3JobDefinition object:

  $service_obj->Method(Att1 => { BucketCriteria => $value, ..., Scoping => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::S3JobDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketCriteria

=head1 DESCRIPTION

Specifies which S3 buckets contain the objects that a classification
job analyzes, and the scope of that analysis. The bucket specification
can be static (bucketDefinitions) or dynamic (bucketCriteria). If it's
static, the job analyzes objects in the same predefined set of buckets
each time the job runs. If it's dynamic, the job analyzes objects in
any buckets that match the specified criteria each time the job starts
to run.

=head1 ATTRIBUTES


=head2 BucketCriteria => L<Paws::Macie2::S3BucketCriteriaForJob>

The property- and tag-based conditions that determine which S3 buckets
to include or exclude from the analysis. Each time the job runs, the
job uses these criteria to determine which buckets contain objects to
analyze. A job's definition can contain a bucketCriteria object or a
bucketDefinitions array, not both.


=head2 BucketDefinitions => ArrayRef[L<Paws::Macie2::S3BucketDefinitionForJob>]

An array of objects, one for each Amazon Web Services account that owns
specific S3 buckets to analyze. Each object specifies the account ID
for an account and one or more buckets to analyze for that account. A
job's definition can contain a bucketDefinitions array or a
bucketCriteria object, not both.


=head2 Scoping => L<Paws::Macie2::Scoping>

The property- and tag-based conditions that determine which S3 objects
to include or exclude from the analysis. Each time the job runs, the
job uses these criteria to determine which objects to analyze.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

