package Net::DashCS::Types::legacyLocationData;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://dashcs.com/api/v1/emergency' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %housenumber_of :ATTR(:get<housenumber>);
my %predirectional_of :ATTR(:get<predirectional>);
my %streetname_of :ATTR(:get<streetname>);
my %suite_of :ATTR(:get<suite>);

__PACKAGE__->_factory(
    [ qw(        housenumber
        predirectional
        streetname
        suite

    ) ],
    {
        'housenumber' => \%housenumber_of,
        'predirectional' => \%predirectional_of,
        'streetname' => \%streetname_of,
        'suite' => \%suite_of,
    },
    {
        'housenumber' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'predirectional' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'streetname' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'suite' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'housenumber' => 'housenumber',
        'predirectional' => 'predirectional',
        'streetname' => 'streetname',
        'suite' => 'suite',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Net::DashCS::Types::legacyLocationData

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
legacyLocationData from the namespace http://dashcs.com/api/v1/emergency.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * housenumber


=item * predirectional


=item * streetname


=item * suite




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Net::DashCS::Types::legacyLocationData
   housenumber =>  $some_value, # string
   predirectional =>  $some_value, # string
   streetname =>  $some_value, # string
   suite =>  $some_value, # string
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

