package WebService::Fastly;

use strict;
use 5.008_005;
our $VERSION = '2.00';

1;
__END__

=encoding utf-8

=head1 NAME

WebService::Fastly - an interface to most facets of the [Fastly API](https://developer.fastly.com/reference/api).

=head1 SYNOPSIS

  use WebService::Fastly;

=head1 DESCRIPTION

Via the Fastly API you can perform any of the operations that are possible within the management console,  including creating services, domains, and backends, configuring rules or uploading your own application code, as well as account operations such as user administration and billing reports. The API is organized into collections of endpoints that allow manipulation of objects related to Fastly services and accounts. For the most accurate and up-to-date API reference content, visit our [Developer Hub](https://developer.fastly.com/reference/api/)

The version of the API Spec document: 1.0.0

=head1 AUTHOR

Fastly Inc., oss@fastly.com

=head1 COPYRIGHT

Copyright 2022- Fastly, Inc.

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

=cut
