package Shipment::Temando::WSDL::Types::QuoteFilter;
{
  $Shipment::Temando::WSDL::Types::QuoteFilter::VERSION = '0.13';
}
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://' . $Shipment::Temando::WSDL::Interfaces::quoting_Service::quoting_port::ns_url . '/schema/2009_06/common.xsd' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %preference_of :ATTR(:get<preference>);
my %carriers_of :ATTR(:get<carriers>);
my %extras_of :ATTR(:get<extras>);

__PACKAGE__->_factory(
    [ qw(        preference
        carriers
        extras

    ) ],
    {
        'preference' => \%preference_of,
        'carriers' => \%carriers_of,
        'extras' => \%extras_of,
    },
    {
        'preference' => 'Shipment::Temando::WSDL::Types::QuotePreference',

        'carriers' => 'Shipment::Temando::WSDL::Types::QuoteFilter::_carriers',

        'extras' => 'Shipment::Temando::WSDL::Types::QuoteFilter::_extras',
    },
    {

        'preference' => 'preference',
        'carriers' => 'carriers',
        'extras' => 'extras',
    }
);

} # end BLOCK




package Shipment::Temando::WSDL::Types::QuoteFilter::_carriers;
{
  $Shipment::Temando::WSDL::Types::QuoteFilter::_carriers::VERSION = '0.13';
}
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %carrier_of :ATTR(:get<carrier>);

__PACKAGE__->_factory(
    [ qw(        carrier

    ) ],
    {
        'carrier' => \%carrier_of,
    },
    {
        'carrier' => 'Shipment::Temando::WSDL::Types::CarrierPreference',
    },
    {

        'carrier' => 'carrier',
    }
);

} # end BLOCK






}



package Shipment::Temando::WSDL::Types::QuoteFilter::_extras;
{
  $Shipment::Temando::WSDL::Types::QuoteFilter::_extras::VERSION = '0.13';
}
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %summary_of :ATTR(:get<summary>);

__PACKAGE__->_factory(
    [ qw(        summary

    ) ],
    {
        'summary' => \%summary_of,
    },
    {
        'summary' => 'Shipment::Temando::WSDL::Types::ExtraSummary',
    },
    {

        'summary' => 'summary',
    }
);

} # end BLOCK






}






1;

__END__

=pod

=head1 NAME

Shipment::Temando::WSDL::Types::QuoteFilter

=head1 VERSION

version 0.13

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
QuoteFilter from the namespace http://' . $Shipment::Temando::WSDL::Interfaces::quoting_Service::quoting_port::ns_url . '/schema/2009_06/common.xsd.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * preference (min/maxOccurs: 0/1)

=item * carriers (min/maxOccurs: 0/1)

=item * extras (min/maxOccurs: 0/1)

=back

=head1 NAME

Shipment::Temando::WSDL::Types::QuoteFilter

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::Temando::WSDL::Types::QuoteFilter
   preference => $some_value, # QuotePreference
   carriers =>  {
     carrier =>  { # Shipment::Temando::WSDL::Types::CarrierPreference
       carrierId => $some_value, # CarrierId
       deliveryMethods =>  {
         deliveryMethod => $some_value, # DeliveryMethod
       },
     },
   },
   extras =>  {
     summary => $some_value, # ExtraSummary
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2013 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
