# Generated by default/object.tt
package Paws::Quicksight::FieldFolder;
  use Moose;
  has Columns => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'columns', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::FieldFolder

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::FieldFolder object:

  $service_obj->Method(Att1 => { Columns => $value, ..., Description => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::FieldFolder object:

  $result = $service_obj->Method(...);
  $result->Att1->Columns

=head1 DESCRIPTION

A FieldFolder element is a folder that contains fields and nested
subfolders.

=head1 ATTRIBUTES


=head2 Columns => ArrayRef[Str|Undef]

A folder has a list of columns. A column can only be in one folder.


=head2 Description => Str

The description for a field folder.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

