# Generated by default/object.tt
package Paws::Glue::PartitionIndexDescriptor;
  use Moose;
  has BackfillErrors => (is => 'ro', isa => 'ArrayRef[Paws::Glue::BackfillError]');
  has IndexName => (is => 'ro', isa => 'Str', required => 1);
  has IndexStatus => (is => 'ro', isa => 'Str', required => 1);
  has Keys => (is => 'ro', isa => 'ArrayRef[Paws::Glue::KeySchemaElement]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::PartitionIndexDescriptor

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::PartitionIndexDescriptor object:

  $service_obj->Method(Att1 => { BackfillErrors => $value, ..., Keys => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::PartitionIndexDescriptor object:

  $result = $service_obj->Method(...);
  $result->Att1->BackfillErrors

=head1 DESCRIPTION

A descriptor for a partition index in a table.

=head1 ATTRIBUTES


=head2 BackfillErrors => ArrayRef[L<Paws::Glue::BackfillError>]

A list of errors that can occur when registering partition indexes for
an existing table.


=head2 B<REQUIRED> IndexName => Str

The name of the partition index.


=head2 B<REQUIRED> IndexStatus => Str

The status of the partition index.

The possible statuses are:

=over

=item *

CREATING: The index is being created. When an index is in a CREATING
state, the index or its table cannot be deleted.

=item *

ACTIVE: The index creation succeeds.

=item *

FAILED: The index creation fails.

=item *

DELETING: The index is deleted from the list of indexes.

=back



=head2 B<REQUIRED> Keys => ArrayRef[L<Paws::Glue::KeySchemaElement>]

A list of one or more keys, as C<KeySchemaElement> structures, for the
partition index.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

