unit module Terminal::ANSI:ver<0.0.1>;

constant CSI = "\e[";

sub nums(*@n) {
 # trim trailing nils?
 @n.map({$_ // ''}).join(';')
}

sub csi($str) {
  if ($*buffer) {
    $*out ~= CSI ~ $str;
  } else {
    print CSI ~ $str;
  }
}

sub esc($str) {
  if ($*buffer) {
    $*out ~= "\e" ~ $str;
  } else {
    print "\e" ~ $str;
  }
}

#| Clear the screen
sub clear-screen is export {
  csi '2J';
}

#| Move the cursor to line, column
sub move-to($l,$c = 0) is export {
  csi nums($l,$c) ~ "H";
}

#| Move to home (0,0)
sub home is export {
  csi 'H';
}

my $scroll-bottom;
my $scroll-top;

#| Set scroll region to top, bottom, left, right
sub set-scroll-region($top,$bottom) is export {
  $scroll-bottom = $bottom;
  $scroll-top = $top;
  csi nums($top,$bottom) ~ "r";
}

#| Reset the scroll region
sub reset-scroll-region is export {
  $scroll-bottom = Nil;
  $scroll-top = Nil;
  csi 'r';
}

#| Scroll down by an amount
sub scroll-down($amt = 1,*@n) is export {
  csi $amt ~ ';' ~ nums(@n) ~ "T"
}

#| Scroll up by an amount
sub scroll-up($amt = 1) is export {
  # csi $amt ~ "S";
  move-to $scroll-bottom, 1 if $scroll-bottom;
  esc "D";
}

#| Hide the cursor
sub hide-cursor is export {
  csi '?25l';
}

#| Show the cursor
sub show-cursor is export {
  csi "?25h";
}

#| Save screen state (smcup)
sub save-screen is export {
  csi '?1049h'
}

#| Restore screen (rmcup)
sub restore-screen is export {
  csi '?1049l'
}

#| Turn off cursor (civis)
sub cursor-off is export {
  csi '?25l'
}

#| Turn on cursor (cnorm)
sub cursor-on is export {
  csi '?25h';
}

#| Move cursor down
sub cursor-down($amt = 1) is export {
  csi $amt ~ 'B';
}

#| Atomic move + print
sub print-at($r,$c,$str) is export {
  csi nums($r,$c) ~ "H" ~ $str;
}

#| Set fg color to $n
sub set-fg-color($n) is export {
  csi "38;5;" ~ $n ~ "m";
}

#| Set bg color to $n
sub set-bg-color($n) is export {
  csi "48;5;" ~ $n ~ "m";
}

#| save the cursor position
sub save-cursor is export {
  csi ~ 's';
}

#| restore the cursor position
sub restore-cursor is export {
  csi ~ 'u';
}

#| save-cursor + print + restore-cursor
sub print-restore($str) is export {
  print CSI ~ 's' ~ $str ~ CSI ~ 'u';
}

sub atomically(&callable) is export {
  my $*buffer = True;
  my $*out = "";
  callable;
  print $*out;
}

