# vim: set ft=perl ts=8 sts=2 sw=2 tw=100 et :
use strictures 2;
use 5.020;
use stable 0.031 'postderef';
use experimental 'signatures';
no autovivification warn => qw(fetch store exists delete);
use if "$]" >= 5.022, experimental => 're_strict';
no if "$]" >= 5.031009, feature => 'indirect';
no if "$]" >= 5.033001, feature => 'multidimensional';
no if "$]" >= 5.033006, feature => 'bareword_filehandles';
use open ':std', ':encoding(UTF-8)'; # force stdin, stdout, stderr into utf8

use JSON::Schema::Tiny 'evaluate';
use lib 't/lib';
use Helper;

my @tests = (
  { schema => false, valid => false },
  { schema => true, valid => true },
  { schema => {}, valid => true },
  { schema => 0, valid => false },
  { schema => 1, valid => false },
  { schema => \0, valid => false },
  { schema => \1, valid => false },
);

BOOLEAN_TESTS:
note '$SCALARREF_BOOLEANS = '.(0+!!$JSON::Schema::Tiny::SCALARREF_BOOLEANS);
foreach my $test (@tests) {
  my $data = 'hello';
  ok(
    lives {
      my $result = evaluate($data, $test->{schema});
      cmp_result(
        $result,
        {
          valid => $test->{valid},
          $test->{valid} ? () : (errors => supersetof()),
        },
        'invalid result structure looks correct',
      );

      local $JSON::Schema::Tiny::BOOLEAN_RESULT = 1;
      my $bool_result = evaluate($data, $test->{schema});
      ok(!($bool_result xor $test->{valid}), json_sprintf('schema: %s evaluates to: %s', $test->{schema}, $test->{valid}));
    },
    'no exceptions in evaluate',
  );
}

if (not $JSON::Schema::Tiny::SCALARREF_BOOLEANS) {
  # schemas still do not accept mojo booleans
  $JSON::Schema::Tiny::SCALARREF_BOOLEANS = 1;
  goto BOOLEAN_TESTS;
}

cmp_result(
  evaluate('hello', []),
  {
    valid => false,
    errors => [
      {
        instanceLocation => '',
        keywordLocation => '',
        error => 'invalid schema type: array',
      },
    ],
  },
  'invalid schema type results in error',
);

cmp_result(
  evaluate('hello', \0),
  {
    valid => false,
    errors => [
      {
        instanceLocation => '',
        keywordLocation => '',
        error => 'invalid schema type: reference to SCALAR',
      },
    ],
  },
  'scalarref for schema results in error, even when $SCALARREF_BOOLEANS is true',
);

done_testing;
