# Generated by default/object.tt
package Paws::NimbleStudio::EulaAcceptance;
  use Moose;
  has AcceptedAt => (is => 'ro', isa => 'Str', request_name => 'acceptedAt', traits => ['NameInRequest']);
  has AcceptedBy => (is => 'ro', isa => 'Str', request_name => 'acceptedBy', traits => ['NameInRequest']);
  has AccepteeId => (is => 'ro', isa => 'Str', request_name => 'accepteeId', traits => ['NameInRequest']);
  has EulaAcceptanceId => (is => 'ro', isa => 'Str', request_name => 'eulaAcceptanceId', traits => ['NameInRequest']);
  has EulaId => (is => 'ro', isa => 'Str', request_name => 'eulaId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NimbleStudio::EulaAcceptance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NimbleStudio::EulaAcceptance object:

  $service_obj->Method(Att1 => { AcceptedAt => $value, ..., EulaId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NimbleStudio::EulaAcceptance object:

  $result = $service_obj->Method(...);
  $result->Att1->AcceptedAt

=head1 DESCRIPTION

This class has no description

=head1 ATTRIBUTES


=head2 AcceptedAt => Str

The Unix epoch timestamp in seconds for when the EULA was accepted.


=head2 AcceptedBy => Str

The ID of the person who accepted the EULA.


=head2 AccepteeId => Str

The ID of the acceptee.


=head2 EulaAcceptanceId => Str

The EULA acceptance ID.


=head2 EulaId => Str

The EULA ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NimbleStudio>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

