# Generated by default/object.tt
package Paws::MediaConvert::AudioChannelTaggingSettings;
  use Moose;
  has ChannelTag => (is => 'ro', isa => 'Str', request_name => 'channelTag', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::AudioChannelTaggingSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::AudioChannelTaggingSettings object:

  $service_obj->Method(Att1 => { ChannelTag => $value, ..., ChannelTag => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::AudioChannelTaggingSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ChannelTag

=head1 DESCRIPTION

When you mimic a multi-channel audio layout with multiple mono-channel
tracks, you can tag each channel layout manually. For example, you
would tag the tracks that contain your left, right, and center audio
with Left (L), Right (R), and Center (C), respectively. When you don't
specify a value, MediaConvert labels your track as Center (C) by
default. To use audio layout tagging, your output must be in a
QuickTime (.mov) container; your audio codec must be AAC, WAV, or AIFF;
and you must set up your audio track to have only one channel.

=head1 ATTRIBUTES


=head2 ChannelTag => Str

You can add a tag for this mono-channel audio track to mimic its
placement in a multi-channel layout. For example, if this track is the
left surround channel, choose Left surround (LS).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

