# Generated by default/object.tt
package Paws::Lightsail::Container;
  use Moose;
  has Command => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'command', traits => ['NameInRequest']);
  has Environment => (is => 'ro', isa => 'Paws::Lightsail::Environment', request_name => 'environment', traits => ['NameInRequest']);
  has Image => (is => 'ro', isa => 'Str', request_name => 'image', traits => ['NameInRequest']);
  has Ports => (is => 'ro', isa => 'Paws::Lightsail::PortMap', request_name => 'ports', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::Container

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::Container object:

  $service_obj->Method(Att1 => { Command => $value, ..., Ports => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::Container object:

  $result = $service_obj->Method(...);
  $result->Att1->Command

=head1 DESCRIPTION

Describes the settings of a container that will be launched, or that is
launched, to an Amazon Lightsail container service.

=head1 ATTRIBUTES


=head2 Command => ArrayRef[Str|Undef]

The launch command for the container.


=head2 Environment => L<Paws::Lightsail::Environment>

The environment variables of the container.


=head2 Image => Str

The name of the image used for the container.

Container images sourced from your Lightsail container service, that
are registered and stored on your service, start with a colon (C<:>).
For example, C<:container-service-1.mystaticwebsite.1>. Container
images sourced from a public registry like Docker Hub don't start with
a colon. For example, C<nginx:latest> or C<nginx>.


=head2 Ports => L<Paws::Lightsail::PortMap>

The open firewall ports of the container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

