# Generated by default/object.tt
package Paws::IoTEventsData::SimpleRuleEvaluation;
  use Moose;
  has InputPropertyValue => (is => 'ro', isa => 'Str', request_name => 'inputPropertyValue', traits => ['NameInRequest']);
  has Operator => (is => 'ro', isa => 'Str', request_name => 'operator', traits => ['NameInRequest']);
  has ThresholdValue => (is => 'ro', isa => 'Str', request_name => 'thresholdValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEventsData::SimpleRuleEvaluation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEventsData::SimpleRuleEvaluation object:

  $service_obj->Method(Att1 => { InputPropertyValue => $value, ..., ThresholdValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEventsData::SimpleRuleEvaluation object:

  $result = $service_obj->Method(...);
  $result->Att1->InputPropertyValue

=head1 DESCRIPTION

Information needed to compare two values with a comparison operator.

=head1 ATTRIBUTES


=head2 InputPropertyValue => Str

The value of the input property, on the left side of the comparison
operator.


=head2 Operator => Str

The comparison operator.


=head2 ThresholdValue => Str

The threshold value, on the right side of the comparison operator.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEventsData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

