# Generated by default/object.tt
package Paws::GlueDataBrew::DataCatalogInputDefinition;
  use Moose;
  has CatalogId => (is => 'ro', isa => 'Str');
  has DatabaseName => (is => 'ro', isa => 'Str', required => 1);
  has TableName => (is => 'ro', isa => 'Str', required => 1);
  has TempDirectory => (is => 'ro', isa => 'Paws::GlueDataBrew::S3Location');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::DataCatalogInputDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::DataCatalogInputDefinition object:

  $service_obj->Method(Att1 => { CatalogId => $value, ..., TempDirectory => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::DataCatalogInputDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->CatalogId

=head1 DESCRIPTION

Represents how metadata stored in the Glue Data Catalog is defined in a
DataBrew dataset.

=head1 ATTRIBUTES


=head2 CatalogId => Str

The unique identifier of the Amazon Web Services account that holds the
Data Catalog that stores the data.


=head2 B<REQUIRED> DatabaseName => Str

The name of a database in the Data Catalog.


=head2 B<REQUIRED> TableName => Str

The name of a database table in the Data Catalog. This table
corresponds to a DataBrew dataset.


=head2 TempDirectory => L<Paws::GlueDataBrew::S3Location>

Represents an Amazon location where DataBrew can store intermediate
results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

