# Generated by default/object.tt
package Paws::CloudFront::KinesisStreamConfig;
  use Moose;
  has RoleARN => (is => 'ro', isa => 'Str', required => 1);
  has StreamARN => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::KinesisStreamConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::KinesisStreamConfig object:

  $service_obj->Method(Att1 => { RoleARN => $value, ..., StreamARN => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::KinesisStreamConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->RoleARN

=head1 DESCRIPTION

Contains information about the Amazon Kinesis data stream where you are
sending real-time log data.

=head1 ATTRIBUTES


=head2 B<REQUIRED> RoleARN => Str

The Amazon Resource Name (ARN) of an AWS Identity and Access Management
(IAM) role that CloudFront can use to send real-time log data to your
Kinesis data stream.

For more information the IAM role, see Real-time log configuration IAM
role
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html#understand-real-time-log-config-iam-role)
in the I<Amazon CloudFront Developer Guide>.


=head2 B<REQUIRED> StreamARN => Str

The Amazon Resource Name (ARN) of the Kinesis data stream where you are
sending real-time log data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

