/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.bitmap.BitmapCheckerFactory;
import com.adobe.epubcheck.css.CSSCheckerFactory;
import com.adobe.epubcheck.dtbook.DTBookCheckerFactory;
import com.adobe.epubcheck.nav.NavCheckerFactory;
import com.adobe.epubcheck.ncx.NCXCheckerFactory;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.ContentChecker;
import com.adobe.epubcheck.opf.ContentCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.GenericContentCheckerFactory;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public class OPFChecker
implements DocumentValidator {
    OCFPackage ocf;
    Report report;
    String path;
    protected XMLValidator opfValidator = new XMLValidator("schema/20/rng/opf.rng");
    protected XMLValidator opfSchematronValidator = new XMLValidator("schema/20/sch/opf.sch");
    XRefChecker xrefChecker;
    protected Hashtable<String, ContentCheckerFactory> contentCheckerFactoryMap;
    OPFHandler opfHandler = null;
    protected EPUBVersion version;
    protected GenericResourceProvider resourceProvider = null;
    XMLParser opfParser = null;

    private void initContentCheckerFactoryMap() {
        Hashtable<String, ContentCheckerFactory> map = new Hashtable<String, ContentCheckerFactory>();
        map.put("application/xhtml+xml", OPSCheckerFactory.getInstance());
        map.put("text/html", OPSCheckerFactory.getInstance());
        map.put("text/x-oeb1-document", OPSCheckerFactory.getInstance());
        map.put("image/jpeg", BitmapCheckerFactory.getInstance());
        map.put("image/gif", BitmapCheckerFactory.getInstance());
        map.put("image/png", BitmapCheckerFactory.getInstance());
        map.put("image/svg+xml", OPSCheckerFactory.getInstance());
        map.put("application/x-dtbook+xml", DTBookCheckerFactory.getInstance());
        map.put("text/css", CSSCheckerFactory.getInstance());
        this.contentCheckerFactoryMap = map;
    }

    public OPFChecker(OCFPackage ocf, Report report, String path, EPUBVersion version) {
        this.ocf = ocf;
        this.resourceProvider = ocf;
        this.report = report;
        this.path = path;
        this.xrefChecker = new XRefChecker(ocf, report, version);
        this.version = version;
        this.initContentCheckerFactoryMap();
    }

    public OPFChecker(String path, GenericResourceProvider resourceProvider, Report report) {
        this.resourceProvider = resourceProvider;
        this.report = report;
        this.path = path;
        this.version = EPUBVersion.VERSION_2;
        this.initContentCheckerFactoryMap();
    }

    public void runChecks() {
        OPFItem item;
        int i;
        if (!this.ocf.hasEntry(this.path)) {
            this.report.error(null, 0, 0, String.format(Messages.OPF_FILE_MISSING, this.path));
            return;
        }
        this.validate();
        if (!this.opfHandler.checkUniqueIdentExists()) {
            this.report.error(this.path, -1, -1, Messages.OPF_UNIQUE_ID_REF_NOT_EXISTING);
        } else {
            this.ocf.setUniqueIdentifier(this.opfHandler.getUid());
        }
        int itemCount = this.opfHandler.getItemCount();
        this.report.info(null, FeatureEnum.ITEMS_COUNT, Integer.toString(itemCount));
        for (i = 0; i < itemCount; ++i) {
            item = this.opfHandler.getItem(i);
            try {
                this.xrefChecker.registerResource(item.getPath(), item.getMimeType(), item.isInSpine(), new FallbackChecker().checkItemFallbacks(item, this.opfHandler, true), new FallbackChecker().checkImageFallbacks(item, this.opfHandler));
            }
            catch (IllegalArgumentException e) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), e.getMessage());
            }
            this.report.info(item.getPath(), FeatureEnum.DECLARED_MIMETYPE, item.getMimeType());
            this.checkItem(item, this.opfHandler);
        }
        this.checkGuide();
        this.checkBindings();
        for (i = 0; i < itemCount; ++i) {
            item = this.opfHandler.getItem(i);
            if (item.path.matches("^[^:/?#]+://.*")) continue;
            this.checkItemContent(item, this.opfHandler);
        }
        this.xrefChecker.checkReferences();
    }

    protected void checkBindings() {
    }

    protected void checkGuide() {
        int refCount = this.opfHandler.getReferenceCount();
        for (int i = 0; i < refCount; ++i) {
            OPFReference ref = this.opfHandler.getReference(i);
            String itemPath = PathUtil.removeAnchor(ref.getHref());
            OPFItem item = this.opfHandler.getItemByPath(itemPath);
            if (item == null) {
                this.report.error(this.path, ref.getLineNumber(), ref.getColumnNumber(), Messages.OPF_GUIDE_REF_UNMANIFESTED + ref.getHref());
                continue;
            }
            if (OPFChecker.isBlessedItemType(item.mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(item.mimeType)) continue;
            this.report.error(this.path, ref.getLineNumber(), ref.getColumnNumber(), Messages.OPF_GUIDE_REF_IS_NO_CONTENT_DOCUMENT + ref.getHref());
        }
    }

    public void initHandler() {
        this.opfHandler = new OPFHandler(this.path, this.report, this.xrefChecker, this.opfParser, this.version);
    }

    public OPFHandler getOPFHandler() {
        return this.opfHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        int errorsSoFar = this.report.getErrorCount();
        int warningsSoFar = this.report.getWarningCount();
        InputStream in = null;
        try {
            in = this.resourceProvider.getInputStream(this.path);
            this.opfParser = new XMLParser(new BufferedInputStream(in), this.path, "opf", this.report, this.version);
            this.initHandler();
            this.opfParser.addXMLHandler(this.opfHandler);
            this.opfParser.addValidator(this.opfValidator);
            this.opfParser.addValidator(this.opfSchematronValidator);
            this.opfParser.process();
        }
        catch (IOException e) {
            this.report.error(this.path, 0, 0, e.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
        int itemCount = this.opfHandler.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            OPFItem item = this.opfHandler.getItem(i);
            if (this.xrefChecker == null) {
                OCFFilenameChecker.checkCompatiblyEscaped(item.getPath(), this.report, this.version);
            }
            this.checkItem(item, this.opfHandler);
        }
        int spineItemCount = this.opfHandler.getSpineItemCount();
        int nonLinearCount = 0;
        for (int i = 0; i < spineItemCount; ++i) {
            OPFItem item = this.opfHandler.getSpineItem(i);
            this.checkSpineItem(item, this.opfHandler);
            if (item.getSpineLinear()) continue;
            ++nonLinearCount;
        }
        if (nonLinearCount == spineItemCount && spineItemCount > 0) {
            this.report.warning(this.path, -1, -1, Messages.OPF_SPINE_ONLY_NON_LINEAR);
        }
        if (this.version == EPUBVersion.VERSION_2) {
            ArrayList<OPFItem> seen = new ArrayList<OPFItem>();
            for (int i = 0; i < this.opfHandler.getSpineItemCount(); ++i) {
                OPFItem item = this.opfHandler.getSpineItem(i);
                if (seen.contains(item)) {
                    this.report.error(this.path, item.getLineNumber(), item.getLineNumber(), String.format(Messages.OPF_SPINE_MULTI_REFS_TO_SAME_ID, item.getId()));
                    continue;
                }
                seen.add(item);
            }
        }
        return errorsSoFar == this.report.getErrorCount() && warningsSoFar == this.report.getWarningCount();
    }

    public static boolean isBlessedItemType(String type, EPUBVersion version) {
        if (version == EPUBVersion.VERSION_2) {
            return type.equals("application/xhtml+xml") || type.equals("application/x-dtbook+xml");
        }
        return type.equals("application/xhtml+xml") || type.equals("image/svg+xml");
    }

    public static boolean isDeprecatedBlessedItemType(String type) {
        return type.equals("text/x-oeb1-document") || type.equals("text/html");
    }

    public static boolean isBlessedStyleType(String type) {
        return type.equals("text/css");
    }

    public static boolean isDeprecatedBlessedStyleType(String type) {
        return type.equals("text/x-oeb1-css");
    }

    public static boolean isBlessedImageType(String type) {
        return type.equals("image/gif") || type.equals("image/png") || type.equals("image/jpeg") || type.equals("image/svg+xml");
    }

    public static boolean isBlessedFontMimetype20(String mime) {
        if (mime == null) {
            return false;
        }
        return mime.startsWith("font/") || mime.startsWith("application/font") || mime.startsWith("application/x-font") || "application/vnd.ms-opentype".equals(mime);
    }

    protected void checkItem(OPFItem item, OPFHandler opfHandler) {
        OPFItem fallbackStyleItem;
        String fallbackStyle;
        OPFItem fallbackItem;
        String mimeType = item.getMimeType();
        String fallback = item.getFallback();
        if (mimeType != null && !mimeType.equals("") && mimeType.matches("[a-zA-Z0-9!#$&+-^_]+/[a-zA-Z0-9!#$&+-^_]+") && (OPFChecker.isDeprecatedBlessedItemType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType))) {
            if (opfHandler.getOpf20PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_MIMETYPE_TEXTHTML_WRONG_FOR_XHTMLOPS);
            } else if (opfHandler.getOpf12PackageFile() && mimeType.equals("text/html")) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_MIMETYPE_TEXTHTML_WRONG_FOR_OEBPS_12);
            } else if (opfHandler.getOpf20PackageFile()) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_MIMETYPE_DEPRECATED, mimeType));
            }
        }
        if (opfHandler.getOpf12PackageFile() && fallback == null) {
            if (OPFChecker.isBlessedItemType(mimeType, this.version)) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_MIMETYPE_IS_BLESSED_ITEM_TYPE, mimeType));
            } else if (OPFChecker.isBlessedStyleType(mimeType)) {
                this.report.warning(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_MIMETYPE_IS_BLESSED_STYLE_TYPE, mimeType));
            }
        }
        if (fallback != null && (fallbackItem = opfHandler.getItemById(fallback)) == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_FALLBACK_ITEM_NOT_FOUND);
        }
        if ((fallbackStyle = item.getFallbackStyle()) != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) == null) {
            this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_FALLBACK_STYLE_ITEM_NOT_FOUND);
        }
    }

    protected void checkItemContent(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        String path = item.getPath();
        String properties = item.getProperties();
        if (mimeType != null) {
            ContentCheckerFactory checkerFactory = item.isNcx() ? NCXCheckerFactory.getInstance() : (item.isNav() ? NavCheckerFactory.getInstance() : this.contentCheckerFactoryMap.get(mimeType));
            if (checkerFactory == null) {
                checkerFactory = GenericContentCheckerFactory.getInstance();
            }
            if (checkerFactory != null) {
                ContentChecker checker = checkerFactory.newInstance(this.ocf, this.report, path, mimeType, properties, this.xrefChecker, this.version);
                checker.runChecks();
            }
        }
    }

    protected void checkSpineItem(OPFItem item, OPFHandler opfHandler) {
        String mimeType = item.getMimeType();
        if (mimeType != null) {
            if (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType) || OPFChecker.isBlessedImageType(mimeType)) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_MIMETYPE_NOT_PERMISSIBLE_IN_SPINE, mimeType));
            } else if (!OPFChecker.isBlessedItemType(mimeType, this.version) && !OPFChecker.isDeprecatedBlessedItemType(mimeType) && item.getFallback() == null) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_SPINE_NONSTANDARD_MIMETYPE_WITHOUT_FALLBACK, mimeType));
            } else if (!(OPFChecker.isBlessedItemType(mimeType, this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType) || new FallbackChecker().checkItemFallbacks(item, opfHandler, true))) {
                this.report.error(this.path, item.getLineNumber(), item.getColumnNumber(), String.format(Messages.OPF_SPINE_NONSTANDARD_MIMETYPE_WITH_NOTALLOWED_FALLBACK, mimeType));
            }
        }
    }

    class FallbackChecker {
        private Set<String> checked = new HashSet<String>();

        protected boolean checkItemFallbacks(OPFItem item, OPFHandler opfHandler, boolean checkFallbackStyle) {
            String mimeType;
            OPFItem fallbackStyleItem;
            String fallback = item.getFallback();
            if (fallback != null) {
                String mimeType2;
                if (this.checked.contains(fallback = fallback.trim())) {
                    OPFChecker.this.report.error(OPFChecker.this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_FALLBACK_CIRCULAR_REF);
                    return false;
                }
                this.checked.add(fallback);
                OPFItem fallbackItem = opfHandler.getItemById(fallback);
                if (fallbackItem != null && (mimeType2 = fallbackItem.getMimeType()) != null) {
                    if (OPFChecker.isBlessedItemType(mimeType2, OPFChecker.this.version) || OPFChecker.isDeprecatedBlessedItemType(mimeType2)) {
                        return true;
                    }
                    if (this.checkItemFallbacks(fallbackItem, opfHandler, checkFallbackStyle)) {
                        return true;
                    }
                }
            }
            if (!checkFallbackStyle) {
                return false;
            }
            String fallbackStyle = item.getFallbackStyle();
            return fallbackStyle != null && (fallbackStyleItem = opfHandler.getItemById(fallbackStyle)) != null && (mimeType = fallbackStyleItem.getMimeType()) != null && (OPFChecker.isBlessedStyleType(mimeType) || OPFChecker.isDeprecatedBlessedStyleType(mimeType));
        }

        protected boolean checkImageFallbacks(OPFItem item, OPFHandler opfHandler) {
            String fallback = item.getFallback();
            if (fallback != null) {
                String mimeType;
                if (this.checked.contains(fallback = fallback.trim())) {
                    OPFChecker.this.report.error(OPFChecker.this.path, item.getLineNumber(), item.getColumnNumber(), Messages.OPF_FALLBACK_CIRCULAR_REF);
                    return false;
                }
                this.checked.add(fallback);
                OPFItem fallbackItem = opfHandler.getItemById(fallback);
                if (fallbackItem != null && (mimeType = fallbackItem.getMimeType()) != null) {
                    if (OPFChecker.isBlessedImageType(mimeType)) {
                        return true;
                    }
                    if (this.checkImageFallbacks(fallbackItem, opfHandler)) {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

