/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FunctionAvailable
extends Available
implements CallableExpression {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        boolean b;
        String lexicalQName = ((Literal)this.argument[0]).getValue().getStringValue();
        StaticContext env = visitor.getStaticContext();
        Configuration config = visitor.getConfiguration();
        long arity = -1L;
        if (this.argument.length == 2) {
            arity = ((NumericValue)this.argument[1].evaluateItem(env.makeEarlyEvaluationContext())).longValue();
        }
        try {
            String[] parts = config.getNameChecker().getQNameParts(lexicalQName);
            String prefix = parts[0];
            String uri = prefix.length() == 0 ? env.getDefaultFunctionNamespace() : env.getURIForPrefix(prefix);
            StructuredQName functionName = new StructuredQName(prefix, uri, parts[1]);
            b = env.getFunctionLibrary().getFunctionSignature(functionName, (int)arity) != null;
        }
        catch (QNameException e) {
            XPathException err = new XPathException(e.getMessage());
            err.setErrorCode("XTDE1400");
            throw err;
        }
        catch (XPathException e2) {
            if ("XTDE0290".equals(e2.getErrorCodeLocalPart())) {
                e2.setErrorCode("XTDE1400");
            }
            throw e2;
        }
        return Literal.makeLiteral(BooleanValue.get(b));
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av1 = (AtomicValue)this.argument[0].evaluateItem(context);
        long arity = -1L;
        if (this.argument.length == 2) {
            arity = ((NumericValue)this.argument[1].evaluateItem(context)).longValue();
        }
        StringValue nameValue = (StringValue)av1;
        String lexicalName = nameValue.getStringValue();
        boolean b = this.isFunctionAvailable(lexicalName, (int)arity, context);
        return BooleanValue.get(b);
    }

    private boolean isFunctionAvailable(String lexicalName, int arity, XPathContext context) throws XPathException {
        StructuredQName qName;
        try {
            if (lexicalName.indexOf(58) < 0) {
                String uri = "http://www.w3.org/2005/xpath-functions";
                qName = new StructuredQName("", uri, lexicalName);
            } else {
                qName = StructuredQName.fromLexicalQName(lexicalName, false, context.getConfiguration().getNameChecker(), this.nsContext);
            }
        }
        catch (XPathException e) {
            e.setErrorCode("XTDE1400");
            e.setLocator(this);
            e.setXPathContext(context);
            throw e;
        }
        FunctionLibraryList lib = context.getController().getExecutable().getFunctionLibrary();
        return lib.getFunctionSignature(qName, arity) != null;
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        String lexicalQName = arguments[0].next().getStringValue();
        int arity = -1;
        if (arguments.length == 2) {
            arity = (int)((NumericValue)arguments[1].next()).longValue();
        }
        boolean b = this.isFunctionAvailable(lexicalQName, arity, context);
        return SingletonIterator.makeIterator(BooleanValue.get(b));
    }
}

