# Generated by default/object.tt
package Paws::MediaConvert::DashIsoGroupSettings;
  use Moose;
  has AdditionalManifests => (is => 'ro', isa => 'ArrayRef[Paws::MediaConvert::DashAdditionalManifest]', request_name => 'additionalManifests', traits => ['NameInRequest']);
  has AudioChannelConfigSchemeIdUri => (is => 'ro', isa => 'Str', request_name => 'audioChannelConfigSchemeIdUri', traits => ['NameInRequest']);
  has BaseUrl => (is => 'ro', isa => 'Str', request_name => 'baseUrl', traits => ['NameInRequest']);
  has Destination => (is => 'ro', isa => 'Str', request_name => 'destination', traits => ['NameInRequest']);
  has DestinationSettings => (is => 'ro', isa => 'Paws::MediaConvert::DestinationSettings', request_name => 'destinationSettings', traits => ['NameInRequest']);
  has Encryption => (is => 'ro', isa => 'Paws::MediaConvert::DashIsoEncryptionSettings', request_name => 'encryption', traits => ['NameInRequest']);
  has FragmentLength => (is => 'ro', isa => 'Int', request_name => 'fragmentLength', traits => ['NameInRequest']);
  has HbbtvCompliance => (is => 'ro', isa => 'Str', request_name => 'hbbtvCompliance', traits => ['NameInRequest']);
  has ImageBasedTrickPlay => (is => 'ro', isa => 'Str', request_name => 'imageBasedTrickPlay', traits => ['NameInRequest']);
  has MinBufferTime => (is => 'ro', isa => 'Int', request_name => 'minBufferTime', traits => ['NameInRequest']);
  has MinFinalSegmentLength => (is => 'ro', isa => 'Num', request_name => 'minFinalSegmentLength', traits => ['NameInRequest']);
  has MpdProfile => (is => 'ro', isa => 'Str', request_name => 'mpdProfile', traits => ['NameInRequest']);
  has PtsOffsetHandlingForBFrames => (is => 'ro', isa => 'Str', request_name => 'ptsOffsetHandlingForBFrames', traits => ['NameInRequest']);
  has SegmentControl => (is => 'ro', isa => 'Str', request_name => 'segmentControl', traits => ['NameInRequest']);
  has SegmentLength => (is => 'ro', isa => 'Int', request_name => 'segmentLength', traits => ['NameInRequest']);
  has WriteSegmentTimelineInRepresentation => (is => 'ro', isa => 'Str', request_name => 'writeSegmentTimelineInRepresentation', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::DashIsoGroupSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::DashIsoGroupSettings object:

  $service_obj->Method(Att1 => { AdditionalManifests => $value, ..., WriteSegmentTimelineInRepresentation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::DashIsoGroupSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalManifests

=head1 DESCRIPTION

Settings related to your DASH output package. For more information, see
https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html.
When you work directly in your JSON job specification, include this
object and any required children when you set Type, under
OutputGroupSettings, to DASH_ISO_GROUP_SETTINGS.

=head1 ATTRIBUTES


=head2 AdditionalManifests => ArrayRef[L<Paws::MediaConvert::DashAdditionalManifest>]

By default, the service creates one .mpd DASH manifest for each DASH
ISO output group in your job. This default manifest references every
output in the output group. To create additional DASH manifests that
reference a subset of the outputs in the output group, specify a list
of them here.


=head2 AudioChannelConfigSchemeIdUri => Str

Use this setting only when your audio codec is a Dolby one (AC3, EAC3,
or Atmos) and your downstream workflow requires that your DASH manifest
use the Dolby channel configuration tag, rather than the MPEG one. For
example, you might need to use this to make dynamic ad insertion work.
Specify which audio channel configuration scheme ID URI MediaConvert
writes in your DASH manifest. Keep the default value, MPEG channel
configuration (MPEG_CHANNEL_CONFIGURATION), to have MediaConvert write
this: urn:mpeg:mpegB:cicp:ChannelConfiguration. Choose Dolby channel
configuration (DOLBY_CHANNEL_CONFIGURATION) to have MediaConvert write
this instead: tag:dolby.com,2014:dash:audio_channel_configuration:2011.


=head2 BaseUrl => Str

A partial URI prefix that will be put in the manifest (.mpd) file at
the top level BaseURL element. Can be used if streams are delivered
from a different URL than the manifest file.


=head2 Destination => Str

Use Destination (Destination) to specify the S3 output location and the
output filename base. Destination accepts format identifiers. If you do
not specify the base filename in the URI, the service will use the
filename of the input file. If your job has multiple inputs, the
service uses the filename of the first input file.


=head2 DestinationSettings => L<Paws::MediaConvert::DestinationSettings>

Settings associated with the destination. Will vary based on the type
of destination


=head2 Encryption => L<Paws::MediaConvert::DashIsoEncryptionSettings>

DRM settings.


=head2 FragmentLength => Int

Length of fragments to generate (in seconds). Fragment length must be
compatible with GOP size and Framerate. Note that fragments will end on
the next keyframe after this number of seconds, so actual fragment
length may be longer. When Emit Single File is checked, the
fragmentation is internal to a single output file and it does not cause
the creation of many output files as in other output types.


=head2 HbbtvCompliance => Str

Supports HbbTV specification as indicated


=head2 ImageBasedTrickPlay => Str

Specify whether MediaConvert generates images for trick play. Keep the
default value, None (NONE), to not generate any images. Choose
Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail
and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails
and full-resolution images of single frames. MediaConvert adds an entry
in the .mpd manifest for each set of images that you generate. A common
application for these images is Roku trick mode. The thumbnails and
full-frame images that MediaConvert creates with this feature are
compatible with this Roku specification:
https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md


=head2 MinBufferTime => Int

Minimum time of initially buffered media that is needed to ensure
smooth playout.


=head2 MinFinalSegmentLength => Num

Keep this setting at the default value of 0, unless you are
troubleshooting a problem with how devices play back the end of your
video asset. If you know that player devices are hanging on the final
segment of your video because the length of your final segment is too
short, use this setting to specify a minimum final segment length, in
seconds. Choose a value that is greater than or equal to 1 and less
than your segment length. When you specify a value for this setting,
the encoder will combine any final segment that is shorter than the
length that you specify with the previous segment. For example, your
segment length is 3 seconds and your final segment is .5 seconds
without a minimum final segment length; when you set the minimum final
segment length to 1, your final segment is 3.5 seconds.


=head2 MpdProfile => Str

Specify whether your DASH profile is on-demand or main. When you choose
Main profile (MAIN_PROFILE), the service signals
urn:mpeg:dash:profile:isoff-main:2011 in your .mpd DASH manifest. When
you choose On-demand (ON_DEMAND_PROFILE), the service signals
urn:mpeg:dash:profile:isoff-on-demand:2011 in your .mpd. When you
choose On-demand, you must also set the output group setting Segment
control (SegmentControl) to Single file (SINGLE_FILE).


=head2 PtsOffsetHandlingForBFrames => Str

Use this setting only when your output video stream has B-frames, which
causes the initial presentation time stamp (PTS) to be offset from the
initial decode time stamp (DTS). Specify how MediaConvert handles PTS
when writing time stamps in output DASH manifests. Choose Match initial
PTS (MATCH_INITIAL_PTS) when you want MediaConvert to use the initial
PTS as the first time stamp in the manifest. Choose Zero-based
(ZERO_BASED) to have MediaConvert ignore the initial PTS in the video
stream and instead write the initial time stamp as zero in the
manifest. For outputs that don't have B-frames, the time stamps in your
DASH manifests start at zero regardless of your choice here.


=head2 SegmentControl => Str

When set to SINGLE_FILE, a single output file is generated, which is
internally segmented using the Fragment Length and Segment Length. When
set to SEGMENTED_FILES, separate segment files will be created.


=head2 SegmentLength => Int

Length of mpd segments to create (in seconds). Note that segments will
end on the next keyframe after this number of seconds, so actual
segment length may be longer. When Emit Single File is checked, the
segmentation is internal to a single output file and it does not cause
the creation of many output files as in other output types.


=head2 WriteSegmentTimelineInRepresentation => Str

If you get an HTTP error in the 400 range when you play back your DASH
output, enable this setting and run your transcoding job again. When
you enable this setting, the service writes precise segment durations
in the DASH manifest. The segment duration information appears inside
the SegmentTimeline element, inside SegmentTemplate at the
Representation level. When you don't enable this setting, the service
writes approximate segment durations in your DASH manifest.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

