# Generated by default/object.tt
package Paws::IoTSiteWise::TumblingWindow;
  use Moose;
  has Interval => (is => 'ro', isa => 'Str', request_name => 'interval', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::TumblingWindow

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::TumblingWindow object:

  $service_obj->Method(Att1 => { Interval => $value, ..., Interval => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::TumblingWindow object:

  $result = $service_obj->Method(...);
  $result->Att1->Interval

=head1 DESCRIPTION

Contains a tumbling window, which is a repeating fixed-sized,
non-overlapping, and contiguous time interval. This window is used in
metric and aggregation computations.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Interval => Str

The time interval for the tumbling window. Note that C<w> represents
weeks, C<d> represents days, C<h> represents hours, and C<m> represents
minutes. AWS IoT SiteWise computes the C<1w> interval the end of Sunday
at midnight each week (UTC), the C<1d> interval at the end of each day
at midnight (UTC), the C<1h> interval at the end of each hour, and so
on.

When AWS IoT SiteWise aggregates data points for metric computations,
the start of each interval is exclusive and the end of each interval is
inclusive. AWS IoT SiteWise places the computed data point at the end
of the interval.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

