# Generated by default/object.tt
package Paws::GameLift::GameServerInstance;
  use Moose;
  has GameServerGroupArn => (is => 'ro', isa => 'Str');
  has GameServerGroupName => (is => 'ro', isa => 'Str');
  has InstanceId => (is => 'ro', isa => 'Str');
  has InstanceStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::GameServerInstance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::GameServerInstance object:

  $service_obj->Method(Att1 => { GameServerGroupArn => $value, ..., InstanceStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::GameServerInstance object:

  $result = $service_obj->Method(...);
  $result->Att1->GameServerGroupArn

=head1 DESCRIPTION

B<This data type is used with the GameLift FleetIQ and game server
groups.>

Additional properties, including status, that describe an EC2 instance
in a game server group. Instance configurations are set with game
server group properties (see C<DescribeGameServerGroup> and with the
EC2 launch template that was used when creating the game server group.

Retrieve game server instances for a game server group by calling
C<DescribeGameServerInstances>.

B<Related actions>

CreateGameServerGroup | ListGameServerGroups | DescribeGameServerGroup
| UpdateGameServerGroup | DeleteGameServerGroup | ResumeGameServerGroup
| SuspendGameServerGroup | DescribeGameServerInstances | All APIs by
task
(https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/reference-awssdk-fleetiq.html)

=head1 ATTRIBUTES


=head2 GameServerGroupArn => Str

A generated unique identifier for the game server group that includes
the game server instance.


=head2 GameServerGroupName => Str

A developer-defined identifier for the game server group that includes
the game server instance. The name is unique for each Region in each
AWS account.


=head2 InstanceId => Str

The unique identifier for the instance where the game server is
running. This ID is available in the instance metadata. EC2 instance
IDs use a 17-character format, for example: C<i-1234567890abcdef0>.


=head2 InstanceStatus => Str

Current status of the game server instance.

=over

=item *

B<ACTIVE> -- The instance is viable for hosting game servers.

=item *

B<DRAINING> -- The instance is not viable for hosting game servers.
Existing game servers are in the process of ending, and new game
servers are not started on this instance unless no other resources are
available. When the instance is put in DRAINING, a new instance is
started up to replace it. Once the instance has no UTILIZED game
servers, it will be terminated in favor of the new instance.

=item *

B<SPOT_TERMINATING> -- The instance is in the process of shutting down
due to a Spot instance interruption. No new game servers are started on
this instance.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

