# Generated by default/object.tt
package Paws::CodeGuruReviewer::CodeArtifacts;
  use Moose;
  has BuildArtifactsObjectKey => (is => 'ro', isa => 'Str');
  has SourceCodeArtifactsObjectKey => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::CodeArtifacts

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::CodeArtifacts object:

  $service_obj->Method(Att1 => { BuildArtifactsObjectKey => $value, ..., SourceCodeArtifactsObjectKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::CodeArtifacts object:

  $result = $service_obj->Method(...);
  $result->Att1->BuildArtifactsObjectKey

=head1 DESCRIPTION

Code artifacts are source code artifacts and build artifacts used in a
repository analysis or a pull request review.

=over

=item *

Source code artifacts are source code files in a Git repository that
are compressed into a .zip file.

=item *

Build artifacts are .jar or .class files that are compressed in a .zip
file.

=back


=head1 ATTRIBUTES


=head2 BuildArtifactsObjectKey => Str

The S3 object key for a build artifacts .zip file that contains .jar or
.class files. This is required for a code review with security
analysis. For more information, see Create code reviews with security
analysis
(https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/code-review-security.html)
in the I<Amazon CodeGuru Reviewer User Guide>.


=head2 B<REQUIRED> SourceCodeArtifactsObjectKey => Str

The S3 object key for a source code .zip file. This is required for all
code reviews.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

