/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.ordering;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.PortSide;

public class PortSideAssigner {
    public void assignPortSides(SelfLoopHolder slHolder) {
        assert (!slHolder.getLNode().getProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS).isSideFixed());
        switch (slHolder.getLNode().getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_DISTRIBUTION)) {
            case NORTH: {
                this.assignToNorthSide(slHolder);
                break;
            }
            case NORTH_SOUTH: {
                this.assignToNorthOrSouthSide(slHolder);
                break;
            }
            case EQUALLY: {
                this.assignToAllSides(slHolder);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        assert (slHolder.getSLPortMap().keySet().stream().noneMatch(lPort -> lPort.getSide() == PortSide.UNDEFINED));
    }

    private void assignToNorthSide(SelfLoopHolder slHolder) {
        slHolder.getSLHyperLoops().stream().flatMap(slLoop -> this.hiddenSelfLoopPortStream((SelfHyperLoop)slLoop)).map(slPort -> slPort.getLPort()).forEach(lPort -> lPort.setSide(PortSide.NORTH));
    }

    private void assignToNorthOrSouthSide(SelfLoopHolder slHolder) {
        int northPorts = 0;
        int southPorts = 0;
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            List slHiddenPorts = this.hiddenSelfLoopPortStream(slLoop).collect(Collectors.toList());
            PortSide newPortSide = null;
            if (northPorts <= southPorts) {
                newPortSide = PortSide.NORTH;
                northPorts += slHiddenPorts.size();
            } else if (southPorts < northPorts) {
                newPortSide = PortSide.SOUTH;
                southPorts += slHiddenPorts.size();
            }
            PortSide finalNewPortSide = newPortSide;
            slHiddenPorts.stream().map(slPort -> slPort.getLPort()).forEach(lPort -> lPort.setSide(finalNewPortSide));
        }
    }

    private void assignToAllSides(SelfLoopHolder slHolder) {
        ArrayList<SelfHyperLoop> slSortedLoops = new ArrayList<SelfHyperLoop>(slHolder.getSLHyperLoops());
        slSortedLoops.sort((slLoop1, slLoop2) -> Integer.compare(slLoop2.getSLPorts().size(), slLoop1.getSLPorts().size()));
        Target[] assignmentTargets = Target.values();
        int currLoop = 0;
        for (SelfHyperLoop slLoop : slSortedLoops) {
            Target currTarget = assignmentTargets[currLoop % assignmentTargets.length];
            this.assignToTarget(slLoop, currTarget);
            ++currLoop;
        }
    }

    private void assignToTarget(SelfHyperLoop slLoop, Target target) {
        SelfLoopPort slPort;
        List<SelfLoopPort> slPorts = slLoop.getSLPorts();
        if (target.isCornerTarget()) {
            slPorts.sort((slPort1, slPort2) -> Integer.compare(slPort1.getLPort().getNetFlow(), slPort2.getLPort().getNetFlow()));
        }
        int secondHalfStartIndex = slPorts.size() / 2;
        int i = 0;
        while (i < secondHalfStartIndex) {
            slPort = slPorts.get(i);
            if (slPort.isHidden()) {
                slPort.getLPort().setSide(target.firstSide);
            }
            ++i;
        }
        i = secondHalfStartIndex;
        while (i < slPorts.size()) {
            slPort = slPorts.get(i);
            if (slPort.isHidden()) {
                slPort.getLPort().setSide(target.secondSide);
            }
            ++i;
        }
    }

    private Stream<SelfLoopPort> hiddenSelfLoopPortStream(SelfHyperLoop slLoop) {
        return slLoop.getSLPorts().stream().filter(slPort -> slPort.isHidden());
    }

    private static enum Target {
        NORTH(PortSide.NORTH, PortSide.NORTH),
        SOUTH(PortSide.SOUTH, PortSide.SOUTH),
        EAST(PortSide.EAST, PortSide.EAST),
        WEST(PortSide.WEST, PortSide.WEST),
        NORTH_WEST_CORNER(PortSide.WEST, PortSide.NORTH),
        NORTH_EAST_CORNER(PortSide.NORTH, PortSide.EAST),
        SOUTH_WEST_CORNER(PortSide.SOUTH, PortSide.WEST),
        SOUTH_EAST_CORNER(PortSide.EAST, PortSide.SOUTH);

        private final PortSide firstSide;
        private final PortSide secondSide;

        private Target(PortSide firstSide, PortSide secondSide) {
            this.firstSide = firstSide;
            this.secondSide = secondSide;
        }

        boolean isCornerTarget() {
            return this.firstSide != this.secondSide;
        }
    }
}

