/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.html.form;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.html.form.Encoding;
import org.jdesktop.html.form.FileParameter;
import org.jdesktop.http.Method;
import org.jdesktop.http.Parameter;
import org.jdesktop.http.Request;
import org.w3c.dom.Document;

public class FormRequest
extends Request {
    private List<Parameter> formParams = new ArrayList<Parameter>();
    private Encoding encoding;
    private String boundary = null;

    public FormRequest() {
        super(Method.POST, null);
        this.setEncoding(Encoding.UrlEncoded);
    }

    public FormRequest(String url) {
        super(Method.POST, url);
        this.setEncoding(Encoding.UrlEncoded);
    }

    public FormRequest(FormRequest source) {
        super(source);
        this.formParams.addAll(source.formParams);
        this.setEncoding(Encoding.UrlEncoded);
    }

    public final Parameter getFormParameter(String name) {
        if (name == null) {
            return null;
        }
        for (Parameter p : this.formParams) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public final void setFormParameter(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.setFormParameter(new Parameter(key, value));
    }

    public final void setFormParameter(String key, File file) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.setFormParameter(new FileParameter(key, file));
    }

    public void setFormParameter(Parameter param) {
        if (param == null) {
            throw new NullPointerException("param cannot be null");
        }
        this.formParams.add(param);
    }

    public final Parameter[] getFormParameters() {
        return this.formParams.toArray(new Parameter[0]);
    }

    public final void setFormParameters(Parameter ... params) {
        this.formParams.clear();
        if (params != null) {
            for (Parameter p : params) {
                this.setFormParameter(p);
            }
        }
    }

    public final Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding enc) {
        Encoding old = this.encoding;
        this.encoding = enc == null ? Encoding.UrlEncoded : enc;
        this.firePropertyChange("encoding", (Object)old, (Object)this.encoding);
        if (this.encoding == Encoding.UrlEncoded) {
            this.setHeader("Content-Type", this.encoding.toString());
        } else {
            String randomSequence = "7d44e178b043433ff";
            this.boundary = "++-----------------------" + randomSequence;
            this.setHeader("Content-Type", (Object)((Object)this.encoding) + "; boundary=" + this.boundary);
        }
    }

    public void setBody(String body) {
    }

    public void setBody(byte[] body) {
    }

    public void setBody(Document body) {
    }

    public void setBody(InputStream body) {
    }

    protected InputStream getBody() throws Exception {
        Parameter[] params = this.getFormParameters();
        for (int i = 0; i < params.length; ++i) {
            params[i] = params[i].clone();
        }
        if (this.encoding == Encoding.MultipartFormData) {
            ArrayList<Object> chunks = new ArrayList<Object>();
            StringBuilder buffer = new StringBuilder();
            for (int index = 0; index < params.length; ++index) {
                if (index > 0) {
                    buffer.append("\r\n");
                }
                buffer.append("--" + this.boundary);
                buffer.append("\r\n");
                Parameter param = params[index];
                buffer.append("Content-Disposition: form-data; name=\"" + param.getName() + "\"");
                if (param instanceof FileParameter) {
                    FileParameter fileParam = (FileParameter)params[index];
                    String filename = fileParam.getFilename();
                    if (filename == null) continue;
                    buffer.append("; filename=\"" + filename + "\"");
                    buffer.append("\r\n");
                    buffer.append("Content-Type: " + fileParam.getContentType());
                    buffer.append("\r\n\r\n");
                    chunks.add(buffer.toString());
                    buffer.delete(0, buffer.length());
                    chunks.add(fileParam);
                    continue;
                }
                buffer.append("\r\n\r\n");
                buffer.append(param.getValue());
            }
            buffer.append("\r\n");
            buffer.append("--" + this.boundary);
            buffer.append("--");
            chunks.add(buffer.toString());
            return new MultipartInputStream(chunks);
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                b.append("&");
            }
            Parameter p = params[i];
            String name = URLEncoder.encode(p.getName(), "UTF-8");
            String value = URLEncoder.encode(p.getValue(), "UTF-8");
            b.append(name);
            b.append("=");
            b.append(value);
        }
        return new ByteArrayInputStream(b.toString().getBytes());
    }

    public String toString() {
        String s = super.toString();
        if (this.encoding == Encoding.MultipartFormData) {
            return s + "\nMultipart Form Data Encoded";
        }
        try {
            StringBuffer b = new StringBuffer();
            Parameter[] params = this.getFormParameters();
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    b.append("&");
                }
                Parameter p = params[i];
                String name = URLEncoder.encode(p.getName(), "UTF-8");
                String value = URLEncoder.encode(p.getValue(), "UTF-8");
                b.append(name);
                b.append("=");
                b.append(value);
            }
            return s + "\n" + b;
        }
        catch (Exception e) {
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MultipartInputStream
    extends InputStream {
        private List<Object> chunks = new ArrayList<Object>();
        private InputStream file = null;
        private String string = null;
        private int index = -1;

        public MultipartInputStream(List<Object> chunks) {
            this.chunks = chunks;
        }

        @Override
        public int read() throws IOException {
            block11: {
                int data;
                boolean tryagain = true;
                while (true) {
                    if (this.string == null && this.file == null) {
                        if (this.chunks.isEmpty()) {
                            return -1;
                        }
                        Object o = this.chunks.remove(0);
                        if (o == null) continue;
                        if (o instanceof String) {
                            this.string = (String)o;
                            this.index = 0;
                        } else if (o instanceof FileParameter) {
                            this.file = ((FileParameter)o).getValueStream();
                        } else {
                            throw new AssertionError((Object)"Cannot happen");
                        }
                    }
                    if (this.string != null) {
                        if (this.index >= this.string.length()) {
                            this.string = null;
                            continue;
                        }
                        return this.string.charAt(this.index++);
                    }
                    if (this.file == null) break block11;
                    data = this.file.read();
                    if (data != -1) break;
                    try {
                        this.file.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.file = null;
                }
                return data;
            }
            throw new AssertionError((Object)"You should never reach this line");
        }
    }
}

